/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.RegExp;
import hlt.language.util.RegExpOne;
import hlt.language.util.RegExpSymbol;

public class RegExpPower
extends RegExpOne {
    private int _power = 1;

    public final int getPower() {
        return this._power;
    }

    @Override
    public final RegExp shallowCopy() {
        return this.power(this._arg, this._power);
    }

    @Override
    public final RegExp deepCopy() {
        return this.power(this._arg.deepCopy(), this._power);
    }

    @Override
    public final int type() {
        return 32;
    }

    public final RegExpPower setPower(int n) {
        this._power = n;
        return this;
    }

    public RegExpPower(RegExp regExp, int n) {
        super(regExp);
        this.setPower(n);
    }

    @Override
    public void normalize() {
        String string = null;
        RegExp regExp = this.arg();
        if (regExp.isEmpty()) {
            string = "[PW:E] ()^n --> ()";
            this._normalForm = RegExpSymbol.EMPTY;
        } else if (this._power <= 0) {
            string = "[PW:0] X^0 --> ()";
            this._normalForm = RegExpSymbol.EMPTY;
        } else if (this._power == 1) {
            string = "[PW:1] X^1 --> X";
            this._normalForm = regExp;
        } else {
            switch (regExp.type()) {
                case 4: {
                    string = "[PW:O] X?^n --> X_0^n";
                    this._normalForm = this.range(regExp.arg(), 0, this._power);
                    break;
                }
                case 8: {
                    string = "[PW:P] X+^n --> X_n~";
                    this._normalForm = this.range(regExp.arg(), this._power);
                    break;
                }
                case 16: {
                    string = "[PW:S] X*^n --> X*";
                    this._normalForm = regExp;
                    break;
                }
                case 32: {
                    string = "[PW:N] X^m^n --> X^m*n";
                    this._normalForm = this.power(regExp.arg(), this.times(regExp.power(), this._power));
                    break;
                }
                case 64: {
                    string = "[PW:R] X_m^n^p --> X_m*p^n*p";
                    this._normalForm = this.range(regExp.arg(), this.times(regExp.lower(), this._power), this.times(regExp.upper(), this._power));
                    break;
                }
            }
        }
        this.traceRule(string);
        this.checkNormalForm();
    }

    @Override
    public final boolean equals(Object object) {
        return super.equals(object) && this._power == ((RegExp)object).power();
    }

    public final String toString() {
        if (this._arg.isBinary()) {
            return "(" + this._arg + ")^" + this._power;
        }
        return this._arg + "^" + this._power;
    }

    @Override
    public final String toNormalString() {
        if (!this.inNormalForm()) {
            return this._normalForm.toNormalString();
        }
        if (this._arg.isBinary()) {
            return "(" + this._arg.toNormalString() + ")^" + this._power;
        }
        return this._arg.toNormalString() + "^" + this._power;
    }
}

