/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.RegExp;

public abstract class RegExpTwo
extends RegExp {
    protected RegExp _left;
    protected RegExp _right;
    protected int _matchingPairCode = -1;
    protected int _matchingArgsCode = -1;
    public static final byte XX = 1;
    public static final byte XO = 2;
    public static final byte XP = 3;
    public static final byte XS = 4;
    public static final byte XN = 5;
    public static final byte XR = 6;
    public static final byte OX = 7;
    public static final byte OO = 8;
    public static final byte OP = 9;
    public static final byte OS = 10;
    public static final byte ON = 11;
    public static final byte OR = 12;
    public static final byte PX = 13;
    public static final byte PO = 14;
    public static final byte PP = 15;
    public static final byte PS = 16;
    public static final byte PN = 17;
    public static final byte PR = 18;
    public static final byte SX = 19;
    public static final byte SO = 20;
    public static final byte SP = 21;
    public static final byte SS = 22;
    public static final byte SN = 23;
    public static final byte SR = 24;
    public static final byte NX = 25;
    public static final byte NO = 26;
    public static final byte NP = 27;
    public static final byte NS = 28;
    public static final byte NN = 29;
    public static final byte NR = 30;
    public static final byte RX = 31;
    public static final byte RO = 32;
    public static final byte RP = 33;
    public static final byte RS = 34;
    public static final byte RN = 35;
    public static final byte RR = 36;

    protected RegExpTwo(RegExp regExp, RegExp regExp2) {
        this._left = this.cleanup(regExp);
        this._right = this.cleanup(regExp2);
    }

    public final RegExp getLeft() {
        return this._left;
    }

    public final RegExp getRight() {
        return this._right;
    }

    public final RegExp normalLeft() {
        return this._left.normalForm();
    }

    public final RegExp normalRight() {
        return this._right.normalForm();
    }

    private static final boolean matchingPair(RegExp regExp, RegExp regExp2) {
        if (regExp.equals(regExp2)) {
            return true;
        }
        if (regExp.isUnary()) {
            return regExp2.isUnary() ? regExp.arg().equals(regExp2.arg()) : regExp.arg().equals(regExp2);
        }
        if (regExp2.isUnary()) {
            return regExp.equals(regExp2.arg());
        }
        return false;
    }

    protected final int matchingPairCode() {
        if (this._matchingPairCode >= 0) {
            return this._matchingPairCode;
        }
        byte by = RegExpTwo.matchingPairCode(this._left, this._right);
        this._matchingPairCode = by;
        return by;
    }

    protected final int matchingArgsCode() {
        if (this._matchingArgsCode >= 0) {
            return this._matchingArgsCode;
        }
        if (this.type() != this._right.type()) {
            return -1;
        }
        byte by = RegExpTwo.matchingPairCode(this._left, this._right.left());
        this._matchingArgsCode = by;
        return by;
    }

    protected final String code(int n) {
        switch (n) {
            case 1: {
                return "XX";
            }
            case 2: {
                return "XO";
            }
            case 3: {
                return "XP";
            }
            case 4: {
                return "XS";
            }
            case 5: {
                return "XN";
            }
            case 6: {
                return "XR";
            }
            case 7: {
                return "OX";
            }
            case 8: {
                return "OO";
            }
            case 9: {
                return "OP";
            }
            case 10: {
                return "OS";
            }
            case 11: {
                return "ON";
            }
            case 12: {
                return "OR";
            }
            case 13: {
                return "PX";
            }
            case 14: {
                return "PO";
            }
            case 15: {
                return "PP";
            }
            case 16: {
                return "PS";
            }
            case 17: {
                return "PN";
            }
            case 18: {
                return "PR";
            }
            case 19: {
                return "SX";
            }
            case 20: {
                return "SO";
            }
            case 21: {
                return "SP";
            }
            case 22: {
                return "SS";
            }
            case 23: {
                return "SN";
            }
            case 24: {
                return "SR";
            }
            case 25: {
                return "NX";
            }
            case 26: {
                return "NO";
            }
            case 27: {
                return "NP";
            }
            case 28: {
                return "NS";
            }
            case 29: {
                return "NN";
            }
            case 30: {
                return "NR";
            }
            case 31: {
                return "RX";
            }
            case 32: {
                return "RO";
            }
            case 33: {
                return "RP";
            }
            case 34: {
                return "RS";
            }
            case 35: {
                return "RN";
            }
            case 36: {
                return "RR";
            }
        }
        return "??";
    }

    private static final byte matchingPairCode(RegExp regExp, RegExp regExp2) {
        if (regExp.equals(regExp2)) {
            return 1;
        }
        if (regExp.isUnary()) {
            if (regExp2.isUnary() && regExp.arg().equals(regExp2.arg())) {
                switch (regExp.type()) {
                    case 4: {
                        switch (regExp2.type()) {
                            case 4: {
                                return 8;
                            }
                            case 8: {
                                return 9;
                            }
                            case 16: {
                                return 10;
                            }
                            case 32: {
                                return 11;
                            }
                            case 64: {
                                return 12;
                            }
                        }
                    }
                    case 8: {
                        switch (regExp2.type()) {
                            case 4: {
                                return 14;
                            }
                            case 8: {
                                return 15;
                            }
                            case 16: {
                                return 16;
                            }
                            case 32: {
                                return 17;
                            }
                            case 64: {
                                return 18;
                            }
                        }
                    }
                    case 16: {
                        switch (regExp2.type()) {
                            case 4: {
                                return 20;
                            }
                            case 8: {
                                return 21;
                            }
                            case 16: {
                                return 22;
                            }
                            case 32: {
                                return 23;
                            }
                            case 64: {
                                return 24;
                            }
                        }
                    }
                    case 32: {
                        switch (regExp2.type()) {
                            case 4: {
                                return 26;
                            }
                            case 8: {
                                return 27;
                            }
                            case 16: {
                                return 28;
                            }
                            case 32: {
                                return 29;
                            }
                            case 64: {
                                return 30;
                            }
                        }
                    }
                    case 64: {
                        switch (regExp2.type()) {
                            case 4: {
                                return 32;
                            }
                            case 8: {
                                return 33;
                            }
                            case 16: {
                                return 34;
                            }
                            case 32: {
                                return 35;
                            }
                            case 64: {
                                return 36;
                            }
                        }
                    }
                }
            }
            if (regExp.arg().equals(regExp2)) {
                switch (regExp.type()) {
                    case 4: {
                        return 7;
                    }
                    case 8: {
                        return 13;
                    }
                    case 16: {
                        return 19;
                    }
                    case 32: {
                        return 25;
                    }
                    case 64: {
                        return 31;
                    }
                }
            }
        }
        if (regExp2.isUnary() && regExp.equals(regExp2.arg())) {
            switch (regExp2.type()) {
                case 4: {
                    return 2;
                }
                case 8: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 32: {
                    return 5;
                }
                case 64: {
                    return 6;
                }
            }
        }
        return 0;
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof RegExp && this.type() == ((RegExp)object).type() && this._left.equals(((RegExpTwo)object).left()) && this._right.equals(((RegExpTwo)object).right());
    }
}

