/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.ArrayList;
import hlt.language.util.IndexEnumeration;
import hlt.language.util.Indexed;
import hlt.language.util.SetEnumeration;
import hlt.language.util.SetIndices;
import hlt.language.util.SetIterator;
import java.util.AbstractList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class SetOf {
    protected AbstractList base;
    protected BitSet carrier = (BitSet)EMPTY_BITSET.clone();
    int[] indices = null;
    private static final BitSet EMPTY_BITSET = new BitSet();
    private static SetOf FULL_SET;

    public SetOf(Object[] objectArray, boolean bl) {
        this.base = bl ? new Vector(objectArray.length) : new ArrayList(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.base.add(objectArray[i]);
        }
        this.carrier = new BitSet(objectArray.length);
    }

    public SetOf(Object[] objectArray) {
        this.base = new ArrayList(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.base.add(objectArray[i]);
        }
        this.carrier = new BitSet(objectArray.length);
    }

    public SetOf(AbstractList abstractList) {
        this.base = abstractList;
        this.carrier = new BitSet(this.base.size());
    }

    public SetOf(AbstractList abstractList, int n) {
        new SetOf(abstractList).add(n);
    }

    public SetOf(Object[] objectArray, int n) {
        new SetOf(objectArray).add(n);
    }

    public SetOf(AbstractList abstractList, Object object) {
        new SetOf(abstractList).add(object);
    }

    public SetOf(Object[] objectArray, Object object) {
        new SetOf(objectArray).add(object);
    }

    public SetOf(SetOf setOf) {
        this.base = setOf.base;
        this.carrier = (BitSet)setOf.carrier.clone();
    }

    public SetOf(Object[] objectArray, BitSet bitSet) {
        this.base = new ArrayList(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            this.base.add(objectArray[i]);
        }
        this.carrier = bitSet;
    }

    public SetOf(AbstractList abstractList, BitSet bitSet) {
        this.base = abstractList;
        this.carrier = bitSet;
    }

    protected AbstractList base() {
        return this.base;
    }

    protected BitSet carrier() {
        return this.carrier;
    }

    public int[] getIndices() {
        if (this.indices == null) {
            this.buildIndices();
        }
        return this.indices;
    }

    final void buildIndices() {
        if (!this.isEmpty()) {
            this.indices = new int[this.size()];
            int n = 0;
            for (int i = 0; i < this.base.size(); ++i) {
                if (!this.carrier.get(i)) continue;
                this.indices[n++] = i;
            }
        }
    }

    public final int size() {
        return this.carrier.cardinality();
    }

    public final SetOf top() {
        if (FULL_SET == null || SetOf.FULL_SET.base != this.base) {
            FULL_SET = new SetOf(this.base);
            for (int i = 0; i < this.base.size(); ++i) {
                SetOf.FULL_SET.carrier.set(i);
            }
        }
        return FULL_SET;
    }

    public final boolean isFull() {
        return this.carrier.equals(this.top().carrier);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final int indexOf(Object object) {
        if (object instanceof Indexed) {
            return ((Indexed)object).index;
        }
        return this.base.indexOf(object);
    }

    public SetOf add(int n) {
        if (this.indices == null) {
            this.carrier.set(n);
            return this;
        }
        if (!this.carrier.get(n)) {
            this.carrier.set(n);
            this.indices = null;
        }
        return this;
    }

    public SetOf add(Object object) {
        this.carrier.set(this.indexOf(object));
        return this;
    }

    public static SetOf add(SetOf setOf, int n) {
        SetOf setOf2 = new SetOf(setOf);
        setOf2.carrier.set(n);
        return setOf2;
    }

    public Object get(int n) {
        if (this.base == null) {
            return null;
        }
        Object var2_2 = null;
        try {
            var2_2 = this.base.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        return var2_2;
    }

    public SetOf remove(int n) {
        if (this.indices == null) {
            this.carrier.clear(n);
            return this;
        }
        if (this.carrier.get(n)) {
            this.carrier.clear(n);
            this.indices = null;
        }
        return this;
    }

    public SetOf remove(Object object) {
        this.carrier.clear(this.indexOf(object));
        return this;
    }

    public static SetOf remove(SetOf setOf, int n) {
        SetOf setOf2 = new SetOf(setOf);
        setOf2.carrier.clear(n);
        return setOf2;
    }

    public final int firstIndex() {
        if (!this.isEmpty()) {
            if (this.indices != null) {
                return this.indices[0];
            }
            for (int i = 0; i < this.base.size(); ++i) {
                if (!this.carrier.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public final Object firstElement() {
        int n = this.firstIndex();
        return n < 0 ? null : this.base.get(n);
    }

    public SetOf union(SetOf setOf) {
        if (this.indices == null) {
            this.carrier.or(setOf.carrier);
            return this;
        }
        if (!setOf.isSubsetOf(this)) {
            this.carrier.or(setOf.carrier);
            this.indices = null;
        }
        return this;
    }

    public static SetOf union(SetOf setOf, SetOf setOf2) {
        SetOf setOf3 = new SetOf(setOf);
        setOf3.carrier.or(setOf2.carrier);
        return setOf3;
    }

    public SetOf intersection(SetOf setOf) {
        if (this.indices == null) {
            this.carrier.and(setOf.carrier);
            return this;
        }
        if (!this.isSubsetOf(setOf)) {
            this.carrier.and(setOf.carrier);
            this.indices = null;
        }
        return this;
    }

    public static SetOf intersection(SetOf setOf, SetOf setOf2) {
        SetOf setOf3 = new SetOf(setOf);
        setOf3.carrier.and(setOf2.carrier);
        return setOf3;
    }

    public SetOf minus(SetOf setOf) {
        if (this.indices == null) {
            this.carrier.or(setOf.carrier);
            this.carrier.xor(setOf.carrier);
            return this;
        }
        if (!SetOf.intersection(this, setOf).isEmpty()) {
            this.carrier.or(setOf.carrier);
            this.carrier.xor(setOf.carrier);
            this.indices = null;
        }
        return this;
    }

    public static SetOf minus(SetOf setOf, SetOf setOf2) {
        SetOf setOf3 = new SetOf(setOf);
        setOf3.carrier.or(setOf2.carrier);
        setOf3.carrier.xor(setOf2.carrier);
        return setOf3;
    }

    public SetOf not() {
        this.carrier.xor(this.top().carrier);
        this.indices = null;
        return this;
    }

    public static SetOf not(SetOf setOf) {
        SetOf setOf2 = new SetOf(setOf);
        setOf2.carrier.xor(setOf.top().carrier);
        return setOf2;
    }

    public final boolean contains(int n) {
        return this.carrier.get(n);
    }

    public final boolean contains(Object object) {
        return this.carrier.get(this.indexOf(object));
    }

    public final boolean isSubsetOf(SetOf setOf) {
        BitSet bitSet = (BitSet)this.carrier.clone();
        bitSet.and(setOf.carrier);
        return this.carrier.equals(bitSet);
    }

    public final boolean isStrictSubsetOf(SetOf setOf) {
        return this.isSubsetOf(setOf) && this.size() != setOf.size();
    }

    public boolean isEqualTo(SetOf setOf) {
        return this.carrier.equals(setOf.carrier);
    }

    public boolean equals(Object object) {
        if (object instanceof SetOf) {
            return this.carrier.equals(((SetOf)object).carrier);
        }
        return false;
    }

    public int hashCode() {
        return this.carrier.hashCode();
    }

    public String toString() {
        Object object = "";
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (((String)object).length() > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + iterator.next().toString();
        }
        return "{" + (String)object + "}";
    }

    public final String toBitString() {
        return this.toBitString('0', '1');
    }

    public final String toBitString(char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.base.size(); ++i) {
            stringBuilder.append(this.carrier.get(i) ? c2 : c);
        }
        return stringBuilder.toString();
    }

    public final Enumeration elements() {
        return new SetEnumeration(this);
    }

    public final Iterator iterator() {
        return new SetIterator(this);
    }

    public final IndexEnumeration indices() {
        return new SetIndices(this);
    }
}

