/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.util;

import hlt.language.util.Comparable;
import hlt.language.util.IntIterator;
import java.util.Iterator;

public abstract class ToIntMap {
    public static final int NOT_FOUND_VALUE = Integer.MIN_VALUE;
    protected Entry[] _table;
    protected int _size;
    protected float _loadFactor;
    protected int _threshold;

    protected final int _setThreshold(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal initial capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("illegal load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this._loadFactor = Math.min(1.0f, f);
        this._threshold = (int)((float)n * this._loadFactor);
        return n;
    }

    public final int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final boolean containsValue(int n) {
        for (int i = 0; i < this._table.length; ++i) {
            Entry entry = this._table[i];
            while (entry != null) {
                if (n == entry.value) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public abstract boolean containsEntry(Entry var1);

    protected final void _rehash() {
        int n = this._table.length;
        Entry[] entryArray = this._table;
        this._table = new Entry[2 * n + 1];
        this._threshold = (int)((float)this._table.length * this._loadFactor);
        for (int i = 0; i < n; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = (entry2.hash() & Integer.MAX_VALUE) % this._table.length;
                entry2.next = this._table[n2];
                this._table[n2] = entry2;
            }
        }
    }

    public abstract int put(Entry var1);

    public final void include(ToIntMap toIntMap) {
        Iterator iterator = toIntMap.iterator();
        while (iterator.hasNext()) {
            this.put((Entry)iterator.next());
        }
    }

    public final void clear() {
        for (int i = 0; i < this._table.length; ++i) {
            this._table[i] = null;
        }
        this._size = 0;
    }

    public final Iterator iterator() {
        return new MapIterator(this._table);
    }

    public abstract IntIterator values();

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ToIntMap)) {
            return false;
        }
        return this.isEqualTo((ToIntMap)object);
    }

    public final boolean isEqualTo(ToIntMap toIntMap) {
        if (toIntMap == this) {
            return true;
        }
        if (toIntMap.size() != this.size()) {
            return false;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (toIntMap.containsEntry((Entry)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            n ^= iterator.next().hashCode();
        }
        return n;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next() + (iterator.hasNext() ? ", " : ""));
        }
        return stringBuilder.append("}").toString();
    }

    protected static class ValueIterator
    implements IntIterator {
        private Iterator _entries;

        ValueIterator(Iterator iterator) {
            this._entries = iterator;
        }

        @Override
        public final boolean hasNext() {
            return this._entries.hasNext();
        }

        @Override
        public final int next() {
            return ((Entry)this._entries.next()).value;
        }
    }

    private static class MapIterator
    implements Iterator {
        private Entry[] _table;
        private Entry _next = null;
        private int _index = -1;

        MapIterator(Entry[] entryArray) {
            this._table = entryArray;
        }

        @Override
        public final boolean hasNext() {
            while (this._next == null && ++this._index < this._table.length) {
                this._next = this._table[this._index];
            }
            return this._next != null;
        }

        public final Object next() {
            Entry entry = this._next;
            this._next = this._next.next;
            return entry;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class Entry
    implements Comparable {
        protected int value;
        protected Entry next;

        abstract int hash();

        public final int setValue(int n) {
            this.value = n;
            return this.value;
        }

        public final int value() {
            return this.value;
        }

        @Override
        public boolean lessThan(Comparable comparable) {
            if (!(comparable instanceof Entry)) {
                return false;
            }
            return this.value < ((Entry)comparable).value();
        }
    }
}

