/*
 * Decompiled with CFR 0.152.
 */
package hlt.math.fuzzy;

import hlt.math.fuzzy.LukasieviczAlgebra;
import hlt.math.fuzzy.ProbabilisticAlgebra;
import hlt.math.fuzzy.ZadehAlgebra;
import hlt.math.matrix.NumberAlgebra;

public abstract class FuzzyAlgebra
extends NumberAlgebra {
    static final ZadehAlgebra zadehAlgebra = (ZadehAlgebra)NumberAlgebra.registeredAlgebra(new ZadehAlgebra());
    static final LukasieviczAlgebra lukasieviczAlgebra = (LukasieviczAlgebra)NumberAlgebra.registeredAlgebra(new LukasieviczAlgebra());
    static final ProbabilisticAlgebra probabilisticAlgebra = (ProbabilisticAlgebra)NumberAlgebra.registeredAlgebra(new ProbabilisticAlgebra());

    @Override
    public String toString() {
        return "Abstract Fuzzy Algebra";
    }

    @Override
    public final double zero() {
        return 0.0;
    }

    @Override
    public final double one() {
        return 1.0;
    }

    @Override
    public final double negation(double d) {
        return this.one() - d;
    }

    @Override
    public final double difference(double d, double d2) {
        return this.sum(d, this.negation(d2));
    }

    public static final void setDefaultAlgebra() {
        NumberAlgebra.setCurrentAlgebra(zadehAlgebra);
    }

    public static final ZadehAlgebra zadehAlgebra() {
        return zadehAlgebra;
    }

    public static final void setZadehAlgebra() {
        NumberAlgebra.setCurrentAlgebra(zadehAlgebra);
    }

    public static final void setLukasieviczAlgebra() {
        NumberAlgebra.setCurrentAlgebra(lukasieviczAlgebra);
    }

    public static final void setProbabilisticAlgebra() {
        NumberAlgebra.setCurrentAlgebra(probabilisticAlgebra);
    }
}

