/*
 * Decompiled with CFR 0.152.
 */
package hlt.math.fuzzy;

import hlt.language.util.DoubleArrayList;
import hlt.language.util.IntArrayList;
import hlt.math.fuzzy.FuzzyAlgebra;
import hlt.math.fuzzy.FuzzyTools;
import hlt.math.matrix.Matrix;
import hlt.math.matrix.NumberAlgebra;

public class FuzzyMatrix
extends Matrix {
    protected final DoubleArrayList degrees = new DoubleArrayList();
    static boolean COPY = true;

    public FuzzyMatrix() {
    }

    private FuzzyMatrix(NumberAlgebra numberAlgebra) {
        NumberAlgebra.setCurrentAlgebra(numberAlgebra);
    }

    public FuzzyMatrix(int n) {
        super(n);
    }

    public FuzzyMatrix(int n, int n2) {
        super(n, n2);
    }

    public FuzzyMatrix(double[][] dArray) {
        super(dArray, !COPY);
    }

    public FuzzyMatrix(double[][] dArray, boolean bl) {
        this.rows = dArray.length;
        this.cols = dArray[0].length;
        if (bl) {
            this.data = new double[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    this.data[i][j] = FuzzyTools.checkFuzzyValue(dArray[i][j]);
                }
            }
        } else {
            this.data = dArray;
        }
    }

    public FuzzyMatrix(FuzzyMatrix fuzzyMatrix) {
        this(fuzzyMatrix.data, true);
    }

    @Override
    public FuzzyMatrix setData(double[][] dArray) {
        return (FuzzyMatrix)super.setData(dArray);
    }

    @Override
    public double set(int n, int n2, double d) {
        return super.set(n, n2, FuzzyTools.checkFuzzyValue(d));
    }

    public FuzzyMatrix reflexive_closure() {
        return new FuzzyMatrix(this.data).i_reflexive_closure();
    }

    public FuzzyMatrix i_reflexive_closure() {
        FuzzyMatrix.dataReflexiveClosure(this.data);
        return this;
    }

    public static final double[][] dataReflexiveClosure(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    public boolean isAntiSymmetric() {
        return FuzzyMatrix.dataIsAntiSymmetric(this.data);
    }

    public static boolean dataIsAntiSymmetric(double[][] dArray) {
        for (int i = 0; i < dArray.length - 1; ++i) {
            for (int j = i + 1; j < dArray[0].length; ++j) {
                if (dArray[i][j] == 0.0 || dArray[j][i] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public FuzzyMatrix symmetric_closure() {
        return new FuzzyMatrix(this.data).i_symmetric_closure();
    }

    public FuzzyMatrix i_symmetric_closure() {
        FuzzyMatrix.dataSymmetricClosure(this.data);
        return this;
    }

    public static final double[][] dataSymmetricClosure(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i + 1; j < dArray[0].length; ++j) {
                dArray[i][j] = FuzzyMatrix.sum(dArray[i][j], dArray[j][i]);
                dArray[j][i] = dArray[i][j];
            }
        }
        return dArray;
    }

    public FuzzyMatrix transitive_closure() {
        return new FuzzyMatrix(this.data).i_transitive_closure();
    }

    public FuzzyMatrix i_transitive_closure() {
        return this.setData(FuzzyMatrix.dataTransitiveClosure(this.data));
    }

    public static final double[][] dataTransitiveClosure(double[][] dArray) {
        double[][] dArray2;
        double[][] dArray3 = dArray;
        boolean bl = false;
        while (!FuzzyMatrix.equalData(dArray3 = FuzzyMatrix.square(dArray2 = FuzzyMatrix.copyData(dArray3)), dArray2)) {
        }
        return dArray3;
    }

    private static final double[][] square(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                for (int k = 0; k < dArray.length; ++k) {
                    dArray2[i][j] = FuzzyMatrix.sum(dArray2[i][j], FuzzyMatrix.product(dArray[i][k], dArray[k][j]));
                }
            }
        }
        return dArray2;
    }

    public FuzzyMatrix preorder_closure() {
        return new FuzzyMatrix(this.data).i_preorder_closure();
    }

    public FuzzyMatrix i_preorder_closure() {
        this.data = FuzzyMatrix.dataPreorderClosure(this.data);
        return this;
    }

    public static double[][] dataPreorderClosure(double[][] dArray) {
        return FuzzyMatrix.dataTransitiveClosure(FuzzyMatrix.dataReflexiveClosure(dArray));
    }

    public FuzzyMatrix similarity_closure() {
        return this.reflexive_closure().i_symmetric_closure().i_transitive_closure();
    }

    public FuzzyMatrix i_similarity_closure() {
        return this.i_reflexive_closure().i_symmetric_closure().i_transitive_closure();
    }

    public IntArrayList[] partition(double d) {
        int n;
        int n2 = this.rows;
        IntArrayList[] intArrayListArray = new IntArrayList[n2];
        for (n = 0; n < n2; ++n) {
            intArrayListArray[n] = new IntArrayList();
            intArrayListArray[n].add(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                if (!(this.data[n][i] >= d)) continue;
                this.merge(intArrayListArray, n, i);
            }
        }
        return intArrayListArray;
    }

    private void merge(IntArrayList[] intArrayListArray, int n, int n2) {
        block6: {
            IntArrayList intArrayList = intArrayListArray[n];
            IntArrayList intArrayList2 = intArrayListArray[n2];
            if (intArrayList == intArrayList2) break block6;
            if (intArrayList2.size() < intArrayList.size()) {
                int n3;
                for (n3 = 0; n3 < intArrayList2.size(); ++n3) {
                    this.insertIndex(intArrayList2.get(n3), intArrayList);
                }
                for (n3 = 0; n3 < intArrayList.size(); ++n3) {
                    intArrayListArray[intArrayList.get((int)n3)] = intArrayList;
                }
            } else {
                int n4;
                for (n4 = 0; n4 < intArrayList.size(); ++n4) {
                    this.insertIndex(intArrayList.get(n4), intArrayList2);
                }
                for (n4 = 0; n4 < intArrayList2.size(); ++n4) {
                    intArrayListArray[intArrayList2.get((int)n4)] = intArrayList2;
                }
            }
        }
    }

    private void insertIndex(int n, IntArrayList intArrayList) {
        int n2;
        int n3 = intArrayList.size();
        for (n2 = 0; n2 < n3 && intArrayList.get(n2) < n; ++n2) {
        }
        if (n != intArrayList.get(n2)) {
            intArrayList.add(n2, n);
        }
    }

    public static final double sup(double d, double d2) {
        return FuzzyMatrix.sum(d, d2);
    }

    public static final double inf(double d, double d2) {
        return FuzzyMatrix.product(d, d2);
    }

    @Override
    public FuzzyMatrix transpose() {
        return new FuzzyMatrix().setData(FuzzyMatrix.dataTranspose(this.data));
    }

    @Override
    public FuzzyMatrix i_transpose() {
        if (!this.isSquare()) {
            throw new RuntimeException("Cannot transpose a non-square matrix in place");
        }
        int n = this.rank();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d = this.data[i][j];
                this.data[i][j] = this.data[j][i];
                this.data[j][i] = d;
            }
        }
        return this;
    }

    public final DoubleArrayList degrees() {
        if (this.degrees.isEmpty()) {
            this.computeDegrees();
        }
        return this.degrees;
    }

    public final DoubleArrayList computeDegrees() {
        this.degrees.setSize(0);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.addDegree(this.data[i][j]);
            }
        }
        return this.degrees;
    }

    protected final DoubleArrayList addDegree(double d) {
        int n;
        for (n = 0; n < this.degrees.size() && d > this.degrees.get(n); ++n) {
        }
        if (d != this.degrees.get(n)) {
            this.degrees.add(n, d);
        }
        return this.degrees;
    }

    public FuzzyMatrix copy() {
        return this.copy(this.data);
    }

    public FuzzyMatrix copy(FuzzyMatrix fuzzyMatrix) {
        return this.copy(fuzzyMatrix.data);
    }

    public FuzzyMatrix copy(double[][] dArray) {
        return new FuzzyMatrix(dArray, COPY);
    }

    public static final FuzzyAlgebra fuzzyAlgebra() {
        return (FuzzyAlgebra)NumberAlgebra.currentAlgebra();
    }

    public static FuzzyMatrix random(int n, int n2) {
        return new FuzzyMatrix().setData(FuzzyMatrix.randomDataArray(n, n2));
    }
}

