/*
 * Decompiled with CFR 0.152.
 */
package hlt.math.matrix;

import hlt.language.util.ArrayList;
import hlt.language.util.IntArrayList;
import hlt.language.util.IntIterator;
import hlt.math.matrix.Matrix;

public class BipartiteGraph
extends Matrix {
    private boolean[][] isEdge;
    private IntArrayList[] succLists;
    private int[] firstSuccs;
    private int[] lastSuccs;
    private IntArrayList[] predLists;
    private int[] firstPreds;
    private int[] lastPreds;
    private int[] numOfSuccs;
    private int[] numOfPreds;
    private char noEdgeChar = (char)32;
    private static ArrayList Edges;

    public BipartiteGraph(double[][] dArray) {
        this.setData(dArray);
        this.initializeGraphComponents();
    }

    public final boolean isEdge(int n, int n2) {
        return this.isEdge[n][n2];
    }

    public final boolean isDualEdge(int n, int n2) {
        return this.isEdge[n2][n];
    }

    public final int numOfSuccessors(int n) {
        return this.numOfSuccs[n];
    }

    public final int numOfPredecessors(int n) {
        return this.numOfPreds[n];
    }

    public final int firstSuccessor(int n) {
        return this.firstSuccs[n];
    }

    public final int lastSuccessor(int n) {
        return this.lastSuccs[n];
    }

    public final int firstPredecessor(int n) {
        return this.firstPreds[n];
    }

    public final int lastPredecessor(int n) {
        return this.lastPreds[n];
    }

    @Override
    public void show() {
        int n;
        BipartiteGraph.jot("\t");
        for (n = 0; n < this.cols; ++n) {
            BipartiteGraph.jot(this.centerColumnHeader(this.headerString(n + 1)));
        }
        BipartiteGraph.ln(2);
        for (n = 0; n < this.rows; ++n) {
            BipartiteGraph.jot(this.headerString(n + 1) + "\t");
            for (int i = 0; i < this.cols; ++i) {
                if (this.isEdge(n, i)) {
                    System.out.printf(BipartiteGraph.floatFormatString(), this.data[n][i]);
                    continue;
                }
                BipartiteGraph.jot(this.noEdgeString());
            }
            BipartiteGraph.ln();
        }
    }

    public void showComponents() {
        int n;
        int n2 = this.rows;
        BipartiteGraph.sln("Showing the successors of each left node:");
        for (n = 0; n < n2; ++n) {
            BipartiteGraph.say("\t" + (n + 1) + ": " + this.numOfSuccs[n] + " succs. = " + this.succSetString(n));
        }
        BipartiteGraph.ln();
        BipartiteGraph.sln("Showing the predecessors of each right node:");
        for (n = 0; n < n2; ++n) {
            BipartiteGraph.say("\t" + (n + 1) + ": " + this.numOfPreds[n] + " preds. = " + this.predSetString(n));
        }
    }

    public final String succSetString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        IntIterator intIterator = this.succsIterator(n);
        while (intIterator.hasNext()) {
            stringBuilder.append(Integer.toString(intIterator.next() + 1));
            if (!intIterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.append('}').toString();
    }

    public final String predSetString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        IntIterator intIterator = this.predsIterator(n);
        while (intIterator.hasNext()) {
            stringBuilder.append(Integer.toString(intIterator.next() + 1));
            if (!intIterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.append('}').toString();
    }

    private int getFirstSucc(int n) {
        if (this.succLists[n].isEmpty()) {
            return -1;
        }
        return this.succLists[n].firstElement();
    }

    private int getLastSucc(int n) {
        if (this.succLists[n].isEmpty()) {
            return -1;
        }
        return this.succLists[n].lastElement();
    }

    private int getFirstPred(int n) {
        if (this.predLists[n].isEmpty()) {
            return -1;
        }
        return this.predLists[n].firstElement();
    }

    private int getLastPred(int n) {
        if (this.predLists[n].isEmpty()) {
            return -1;
        }
        return this.predLists[n].lastElement();
    }

    private final void initializeGraphComponents() {
        int n;
        int n2;
        int n3 = this.rows;
        this.isEdge = new boolean[n3][n3];
        this.numOfSuccs = new int[n3];
        this.numOfPreds = new int[n3];
        this.succLists = new IntArrayList[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.succLists[n2] = new IntArrayList();
            for (n = 0; n < n3; ++n) {
                this.isEdge[n2][n] = this.data[n2][n] != 0.0;
                if (!this.isEdge[n2][n]) continue;
                this.succLists[n2].add(n);
                int n4 = n2;
                this.numOfSuccs[n4] = this.numOfSuccs[n4] + 1;
            }
        }
        this.predLists = new IntArrayList[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.predLists[n2] = new IntArrayList();
            for (n = 0; n < n3; ++n) {
                if (!this.isEdge[n][n2]) continue;
                this.predLists[n2].add(n);
                int n5 = n2;
                this.numOfPreds[n5] = this.numOfPreds[n5] + 1;
            }
        }
        this.firstSuccs = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.firstSuccs[n2] = this.getFirstSucc(n2);
        }
        this.lastSuccs = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.lastSuccs[n2] = this.getFirstSucc(n2);
        }
        this.firstPreds = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.firstPreds[n2] = this.getFirstPred(n2);
        }
        this.lastPreds = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.lastPreds[n2] = this.getLastPred(n2);
        }
    }

    public IntIterator succsIterator(int n) {
        return this.succLists[n].iterator();
    }

    public IntIterator predsIterator(int n) {
        return this.predLists[n].iterator();
    }

    private final String headerString(int n) {
        return "[" + n + "]";
    }

    private final String centerColumnHeader(String string) {
        int n;
        int n2 = string.length();
        int n3 = (BipartiteGraph.printWidth() - n2) / 2 + 2;
        int n4 = BipartiteGraph.printWidth() - n3 - n2 - 1;
        char c = ' ';
        StringBuilder stringBuilder = new StringBuilder(c);
        for (n = 0; n < n3; ++n) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        for (n = 0; n < n4; ++n) {
            stringBuilder.append(c);
        }
        return stringBuilder.append(c).toString();
    }

    private String noEdgeString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < BipartiteGraph.printWidth(); ++i) {
            stringBuilder.append(this.noEdgeChar);
        }
        return stringBuilder.toString();
    }
}

