/*
 * Decompiled with CFR 0.152.
 */
package hlt.math.matrix;

import hlt.language.tools.Misc;
import hlt.math.matrix.IncompatibleMatrixDimensionException;
import hlt.math.matrix.NumberAlgebra;

public class Matrix {
    protected int rows;
    protected int cols;
    protected double[][] data;
    private static int printWidth = 9;
    private static double COIN_TOSS_BIAS = 0.5;
    private static int MAX_SIGNIFICANT_DIGITS = 5;
    private static int CURRENT_SIGNIFICANT_DIGITS = 1;
    private static double THRESHOLD0 = 0.0;
    private static double THRESHOLD1 = 0.0;

    public Matrix() {
    }

    protected Matrix(NumberAlgebra numberAlgebra) {
        NumberAlgebra.setCurrentAlgebra(numberAlgebra);
    }

    public Matrix(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RuntimeException("Illegal matrix dimensions: (" + n + "," + n2 + ")");
        }
        this.rows = n;
        this.cols = n2;
        this.data = new double[n][n2];
    }

    public Matrix(int n) {
        if (n <= 0) {
            throw new RuntimeException("Illegal square matrix order: (" + n + ")");
        }
        this.rows = n;
        this.cols = n;
        this.data = new double[n][n];
    }

    public Matrix(double[][] dArray) {
        this(dArray, false);
    }

    public Matrix(double[][] dArray, boolean bl) {
        if (bl) {
            this.setData(dArray);
        } else {
            this.rows = dArray.length;
            this.cols = dArray[0].length;
            this.data = Matrix.copyData(dArray);
        }
    }

    protected Matrix(Matrix matrix) {
        this(matrix.data);
    }

    public final int rank() {
        return this.rows;
    }

    public final int order() {
        return this.rows;
    }

    public final int rows() {
        return this.rows;
    }

    public final int cols() {
        return this.cols;
    }

    public final double[][] data() {
        return this.data;
    }

    public double set(int n, int n2, double d) {
        this.checkLegalEntry(n--, n2--);
        return this.safeDataUpdate(n, n2, Matrix.truncate(d));
    }

    protected final double safeDataUpdate(int n, int n2, double d) {
        double d2 = this.data[n][n2];
        this.data[n][n2] = d;
        return d2;
    }

    public Matrix update(Matrix matrix) {
        if (this.rows != matrix.rows || this.cols != matrix.cols) {
            throw new RuntimeException("Incompatible matrix dimensions: <" + this.rows + "," + this.cols + "> =/= <" + matrix.rows + "," + matrix.cols + ">");
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = matrix.data[i][j];
            }
        }
        return this;
    }

    public final double get(int n, int n2) {
        this.checkLegalEntry(n--, n2--);
        return this.data[n][n2];
    }

    public Matrix setData(double[][] dArray) {
        if (dArray == null) {
            throw new RuntimeException("Attempt to initialize a matrix with a null data array");
        }
        this.rows = dArray.length;
        this.cols = dArray[0].length;
        this.data = dArray;
        return this;
    }

    public static double sum(double d, double d2) {
        return NumberAlgebra.getCurrentAlgebra().sum(d, d2);
    }

    public static double product(double d, double d2) {
        return NumberAlgebra.getCurrentAlgebra().product(d, d2);
    }

    public static double difference(double d, double d2) {
        return NumberAlgebra.getCurrentAlgebra().difference(d, d2);
    }

    public static double negation(double d) {
        return NumberAlgebra.getCurrentAlgebra().negation(d);
    }

    public Matrix plus(Matrix matrix) {
        return new Matrix().setData(this.dataPlus(this.data, matrix.data));
    }

    protected final double[][] dataPlus(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Matrix.verifyCompatibleDimension(n, n2, dArray2.length, dArray2[0].length);
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3[i][j] = Matrix.sum(dArray[i][j], dArray2[i][j]);
            }
        }
        return dArray3;
    }

    public Matrix i_plus(Matrix matrix) {
        Matrix.verifyCompatibleDimension(matrix.rows, matrix.cols, this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = Matrix.sum(this.data[i][j], matrix.data[i][j]);
            }
        }
        return this;
    }

    public Matrix times(Matrix matrix) {
        if (this.cols != matrix.rows) {
            throw new RuntimeException("Cannot multiply a " + this.rows + "x" + this.cols + " matrix by a " + matrix.rows + "x" + matrix.cols + " matrix");
        }
        Matrix matrix2 = new Matrix(this.rows, matrix.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < matrix.cols; ++j) {
                double d = 0.0;
                for (int k = 0; k < this.cols; ++k) {
                    d = Matrix.sum(d, Matrix.product(this.data[i][k], matrix.data[k][j]));
                }
                matrix2.data[i][j] = Matrix.truncate(d);
            }
        }
        return matrix2;
    }

    public Matrix i_times(Matrix matrix) {
        return this.setData(this.times((Matrix)matrix).data);
    }

    public Matrix minus(Matrix matrix) {
        Matrix.verifyCompatibleDimension(matrix.rows, matrix.cols, this.rows, this.cols);
        Matrix matrix2 = new Matrix(this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                matrix2.data[i][j] = Matrix.difference(this.data[i][j], matrix.data[i][j]);
            }
        }
        return matrix2;
    }

    public Matrix i_minus(Matrix matrix) {
        Matrix.verifyCompatibleDimension(matrix.rows, matrix.cols, this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = Matrix.difference(this.data[i][j], matrix.data[i][j]);
            }
        }
        return this;
    }

    public Matrix minus() {
        Matrix matrix = new Matrix(this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                matrix.data[i][j] = Matrix.negation(this.data[i][j]);
            }
        }
        return matrix;
    }

    public Matrix i_minus() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = Matrix.negation(this.data[i][j]);
            }
        }
        return this;
    }

    public Matrix scale(double d) {
        Matrix matrix = new Matrix(this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                matrix.data[i][j] = Matrix.truncate(d * this.data[i][j]);
            }
        }
        return matrix;
    }

    public Matrix i_scale(double d) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = Matrix.truncate(d * this.data[i][j]);
            }
        }
        return this;
    }

    public final boolean equal(Matrix matrix) {
        Matrix.verifyCompatibleDimension(matrix.rows, matrix.cols, this.rows, this.cols);
        return Matrix.equalData(this.data, matrix.data);
    }

    public void swapRows(int n, int n2) {
        double[] dArray = this.data[n];
        this.data[n] = this.data[n2];
        this.data[n2] = dArray;
    }

    public void swapCols(int n, int n2) {
        for (int i = 0; i < this.data.length; ++i) {
            double d = this.data[i][n];
            this.data[i][n] = this.data[i][n2];
            this.data[i][n2] = d;
        }
    }

    public Matrix transpose() {
        return new Matrix().setData(Matrix.dataTranspose(this.data));
    }

    public boolean equals(Matrix matrix) {
        Matrix matrix2 = this;
        if (matrix2 == matrix) {
            return true;
        }
        if (matrix2.data == matrix.data) {
            return true;
        }
        if (matrix.rows != matrix2.rows || matrix.cols != matrix2.cols) {
            throw new RuntimeException("Incompatible matrix dimensions: <" + matrix2.rows + "," + matrix2.cols + "> =/= <" + matrix.rows + "," + matrix.cols + ">");
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (matrix2.data[i][j] == matrix.data[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isVacuous() {
        return this.data == null;
    }

    public boolean isDegenerate() {
        return this.degenerateRow() != -1 || this.degenerateCol() != -1;
    }

    public int degenerateRow() {
        for (int i = 0; i < this.rows; ++i) {
            boolean bl = true;
            for (int j = 0; bl && j < this.cols; ++j) {
                bl = this.data[i][j] == 0.0;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public int degenerateCol() {
        for (int i = 0; i < this.cols; ++i) {
            boolean bl = true;
            for (int j = 0; bl && j < this.rows; ++j) {
                bl = this.data[j][i] == 0.0;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public boolean isZeroMatrix() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (this.data[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isRowStochastic() {
        return this.isRowStochastic(this.data);
    }

    public final void makeRowStochastic() {
        for (int i = 0; i < this.rows; ++i) {
            this.normalizeRow(i);
        }
    }

    public final boolean isColumnStochastic() {
        return this.isColumnStochastic(this.data);
    }

    public final boolean isDoublyStochastic() {
        return this.isDoublyStochastic(this.data);
    }

    protected final boolean isRowStochastic(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                if (dArray[i][j] < 0.0 || dArray[i][j] > 1.0) {
                    return false;
                }
                d = Matrix.sum(d, dArray[i][j]);
            }
            if (Matrix.truncate(d) == 1.0) continue;
            return false;
        }
        return true;
    }

    protected final boolean isColumnStochastic(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                if (dArray[j][i] < 0.0 || dArray[j][i] > 1.0) {
                    return false;
                }
                d = Matrix.sum(d, dArray[j][i]);
            }
            if (Matrix.truncate(d) == 1.0) continue;
            return false;
        }
        return true;
    }

    protected final boolean isDoublyStochastic(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            double d = 0.0;
            for (int i = 0; i < n3; ++i) {
                if (dArray[n][i] < 0.0 || dArray[n][i] > 1.0) {
                    return false;
                }
                d = Matrix.sum(d, dArray[n][i]);
                dArray2[n] = Matrix.sum(dArray2[n], dArray[n][i]);
            }
            if (d == 1.0) continue;
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (Matrix.truncate(dArray2[n]) == 1.0) continue;
            return false;
        }
        return true;
    }

    private final void normalizeRow(int n) {
        double d = 0.0;
        System.err.println();
        System.err.println("------------------------------------------------------------------------");
        System.err.println("Row sum [" + n + "]:");
        System.err.println("------------------------------------------------------------------------");
        System.err.println();
        for (int i = 0; i < this.cols; ++i) {
            this.data[n][i] = Matrix.truncate(this.data[n][i]);
            if (this.data[n][i] < 0.0) {
                throw new RuntimeException("Negative data array entry " + this.data[n][i] + " at indices " + n + "," + i + ": can only make non-negative matrix row-stochastic.");
            }
            System.err.print(" ");
            System.err.printf(Matrix.floatFormatString(), this.data[n][i]);
            System.err.print(i < this.cols - 1 ? "+" : "");
            d = Matrix.sum(d, this.data[n][i]);
        }
        d = Matrix.truncate(d);
        System.err.println(" ---> rowSum[" + n + "] = " + d);
        if (d == 0.0) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.cols; ++i) {
            if (this.data[n][i] == d) {
                d3 = 1.0;
                d2 = 1.0;
                this.data[n][i] = 1.0;
                return;
            }
            double d4 = Matrix.truncate(this.data[n][i] / d);
            System.err.print(" ");
            System.err.printf(Matrix.floatFormatString(), d4);
            System.err.print(i < this.cols - 1 ? "+" : "");
            if (i == this.lastNonZeroColInRow(n)) {
                this.data[n][i] = Matrix.difference(1.0, d3);
                d3 = Matrix.sum(d3, d4);
                d2 = 1.0;
                continue;
            }
            d3 = Matrix.sum(d3, d4);
            this.data[n][i] = d4;
        }
        System.err.println(" ---> actualNormalizedRowSum[" + n + "] = " + d3);
        System.err.println();
        if (Matrix.truncate(d3) == 1.0) {
            System.err.println("Actual normalized sum of row[" + n + "] is close enough to 1.0: so row[" + n + "] is deemed row-stochastic");
        } else {
            System.err.println("Actual normalized sum of row[" + n + "] is NOT close enough to 1.0: so row[" + n + "] is NOT row-stochastic");
        }
        System.err.println("------------------------------------------------------------------------");
    }

    public final int firstNonZeroColInRow(int n) {
        int n2;
        for (n2 = 0; n2 < this.cols && this.data[n][n2] == 0.0; ++n2) {
        }
        return n2 == this.cols ? -1 : n2;
    }

    public final int firstNonZeroRowInColumn(int n) {
        int n2;
        for (n2 = 0; n2 < this.rows && this.data[n2][n2] == 0.0; ++n2) {
        }
        return n2 == this.rows ? -1 : n2;
    }

    public final int lastNonZeroColInRow(int n) {
        int n2;
        for (n2 = this.cols - 1; n2 > 0 && this.data[n][n2] == 0.0; --n2) {
        }
        return n2;
    }

    public final int lastNonZeroRowInColumn(int n) {
        int n2;
        for (n2 = this.rows - 1; n2 > 0 && this.data[n2][n2] == 0.0; --n2) {
        }
        return n2;
    }

    public final boolean isSquare() {
        return this.rows == this.cols;
    }

    public final double trace() {
        if (!this.isSquare()) {
            throw new RuntimeException("Can only compute trace of a non-square matrix");
        }
        double d = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            d += this.data[i][i];
        }
        return d;
    }

    public final boolean isDiagonal() {
        if (!this.isSquare()) {
            return false;
        }
        for (int i = 0; i < this.rows - 1; ++i) {
            for (int j = 1; j < this.cols; ++j) {
                if (this.data[i][j] == 0.0 && this.data[j][i] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix i_transpose() {
        if (!this.isSquare()) {
            throw new RuntimeException("Cannot transpose a non-square matrix in place!");
        }
        for (int i = 0; i < this.rows - 1; ++i) {
            for (int j = 1; j < this.cols; ++j) {
                if (this.data[j][i] == this.data[i][j]) continue;
                this.data[j][i] = this.safeDataUpdate(i, j, this.data[j][i]);
            }
        }
        return this;
    }

    public boolean isVector() {
        return this.isRowVector() || this.isColVector();
    }

    public boolean isRowVector() {
        return this.rows == 1;
    }

    public boolean isColVector() {
        return this.cols == 1;
    }

    public void show() {
        System.out.println();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                System.out.printf(Matrix.floatFormatString(), this.data[i][j]);
            }
            System.out.println();
        }
        System.out.println();
    }

    protected final void showData() {
        Matrix.showDataArray(this.data);
    }

    protected static final boolean equalData(double[][] dArray, double[][] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                if (dArray[i][j] == dArray2[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static final double[][] dataTranspose(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    protected static final void showDataArray(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                System.out.printf(Matrix.floatFormatString(), dArray[i][j]);
            }
            System.out.println();
        }
    }

    public static Matrix newSquareMatrix(int n) {
        return new Matrix(n);
    }

    public static boolean isZeroEntry(double d) {
        return Math.abs(d) < Matrix.currentPrecision();
    }

    public static final double[][] copyData(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static Matrix identity(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return new Matrix(dArray);
    }

    protected static final void verifyCompatibleDimension(int n, int n2, int n3, int n4) {
        if (n != n3 || n2 != n4) {
            throw new IncompatibleMatrixDimensionException(n, n2, n3, n4);
        }
    }

    protected final void checkLegalEntry(int n, int n2) {
        Matrix.checkLegalIndex(n, this.data.length);
        Matrix.checkLegalIndex(n2, this.data[0].length);
    }

    protected static final void checkLegalIndex(int n, int n2) {
        if (n < 1 || n > n2) {
            throw new RuntimeException("Matrix index " + n + " out of bounds [1," + n2 + "]");
        }
    }

    protected static final void checkForStochasticEntries(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                if (!(dArray[i][j] < 0.0) && !(dArray[i][j] > 1.0)) continue;
                throw new RuntimeException("Non-stochastic entry in data array at (row,col): (" + i + "," + j + ")");
            }
        }
    }

    public static final int printWidth() {
        return printWidth;
    }

    public static final int setPrintWidth(int n) {
        printWidth = Math.max(3, n);
        return printWidth;
    }

    public static final int resetPrintWidth() {
        return Matrix.setPrintWidth(9);
    }

    public static String floatFormatString() {
        return "%" + Integer.toString(printWidth) + "." + Integer.toString(Matrix.currentSignificantDigits()) + "f";
    }

    public static double[][] randomDataArray(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = Matrix.randomValue();
            }
        }
        return dArray;
    }

    public static double[][] randomDataArray(int n, int n2, double d) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = Matrix.randomValue(d);
            }
        }
        return dArray;
    }

    public static final boolean headsOrTail() {
        return Math.random() < COIN_TOSS_BIAS;
    }

    public static final double bias() {
        return COIN_TOSS_BIAS;
    }

    public static final double setBias(double d) {
        COIN_TOSS_BIAS = Math.max(0.0, Math.min(1.0, d));
        return COIN_TOSS_BIAS;
    }

    public static final double resetBias() {
        COIN_TOSS_BIAS = 0.5;
        return 0.5;
    }

    public static final double truncate(double d) {
        return d;
    }

    private static final double round(double d) {
        return d;
    }

    public static final double[][] truncate(double[][] dArray) {
        if (dArray == null) {
            throw new RuntimeException("Vacuous data array");
        }
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = Matrix.truncate(dArray[i][j]);
            }
        }
        return dArray;
    }

    public static final int maxSignificantDigits() {
        return MAX_SIGNIFICANT_DIGITS;
    }

    public static final int setMaxSignificantDigits(int n) {
        MAX_SIGNIFICANT_DIGITS = Math.max(1, n);
        return MAX_SIGNIFICANT_DIGITS;
    }

    public static int currentSignificantDigits() {
        return CURRENT_SIGNIFICANT_DIGITS;
    }

    public static final int setCurrentSignificantDigits(int n) {
        CURRENT_SIGNIFICANT_DIGITS = Math.min(Math.max(1, n), Matrix.maxSignificantDigits());
        return CURRENT_SIGNIFICANT_DIGITS;
    }

    public static final double currentPrecision() {
        return Math.pow(10.0, -CURRENT_SIGNIFICANT_DIGITS);
    }

    public static final double threshold0() {
        return THRESHOLD0;
    }

    public static final double threshold1() {
        return THRESHOLD1;
    }

    public static double setThreshold0(double d) {
        THRESHOLD0 = Math.min(Math.max(0.0, d), 1.0);
        return THRESHOLD0;
    }

    public static double resetThreshold0() {
        THRESHOLD0 = 0.0;
        return 0.0;
    }

    public static double setThreshold1(double d) {
        THRESHOLD1 = Math.min(Math.max(0.0, d), 1.0);
        return THRESHOLD1;
    }

    public static double resetThreshold1() {
        THRESHOLD1 = 0.0;
        return 0.0;
    }

    public static void resetThresholds() {
        Matrix.resetThreshold0();
        Matrix.resetThreshold1();
    }

    protected static double randomValue() {
        double d = Matrix.truncate(Math.random());
        double d2 = Matrix.threshold0();
        double d3 = Matrix.threshold1();
        if (d < d2) {
            return Matrix.headsOrTail() ? d : 0.0;
        }
        if (1.0 - d < d3) {
            return Matrix.headsOrTail() ? d : 1.0;
        }
        return d;
    }

    public static void showParameters() {
        Matrix.ln();
        Matrix.say("--------------------------------------------------------------------");
        Matrix.say("Matrix class parameter settings:");
        Matrix.say("--------------------------------------------------------------------");
        Matrix.say("    current number algebra = " + NumberAlgebra.getCurrentAlgebra());
        Matrix.jot("    significant number of digits = " + Matrix.currentSignificantDigits());
        Matrix.say(" (i.e., precision = " + Matrix.currentPrecision() + ")");
        Matrix.jot("    floating-point print width = " + Matrix.printWidth());
        Matrix.say(" (i.e., format string = " + Matrix.floatFormatString() + ")");
        Matrix.say("    random number generation parameters:");
        Matrix.say("    \tthreshold to 0.0 = " + Matrix.threshold0());
        Matrix.say("    \tthreshold to 1.0 = " + Matrix.threshold1());
        Matrix.say("    \tcoin-toss bias   = " + Matrix.bias());
        Matrix.say("--------------------------------------------------------------------");
    }

    private static double randomValue(double d) {
        return Matrix.truncate(d * Matrix.randomValue());
    }

    public static Matrix randomSquare(int n) {
        return Matrix.random(n, n);
    }

    public static Matrix randomSquare(int n, double d) {
        return Matrix.random(n, n, d);
    }

    public static Matrix random(int n, int n2) {
        return new Matrix().setData(Matrix.randomDataArray(n, n2));
    }

    public static Matrix random(int n, int n2, double d) {
        return new Matrix().setData(Matrix.randomDataArray(n, n2, d));
    }

    public static void ln() {
        Misc.ln();
    }

    public static void ln(int n) {
        Misc.ln(n);
    }

    public static void jot(String string) {
        Misc.jot(string);
    }

    public static void say(String string) {
        Misc.say(string);
    }

    public static void sln(String string) {
        Misc.sln(string);
    }
}

