/*
 * Decompiled with CFR 0.152.
 */
package hlt.math.matrix;

import hlt.math.matrix.MaxMinAlgebra;
import hlt.math.matrix.StandardAlgebra;
import java.util.HashMap;
import java.util.Iterator;

public abstract class NumberAlgebra {
    private static StandardAlgebra standardAlgebra;
    private static MaxMinAlgebra maxMinAlgebra;
    private static NumberAlgebra currentAlgebra;
    private static final HashMap algebras;

    protected NumberAlgebra() {
    }

    public double zero() {
        return 0.0;
    }

    public double one() {
        return 1.0;
    }

    public double sum(double d, double d2) {
        return d + d2;
    }

    public double product(double d, double d2) {
        return d * d2;
    }

    public double difference(double d, double d2) {
        return d - d2;
    }

    public double negation(double d) {
        return -d;
    }

    public String toString() {
        return "Number Algebra";
    }

    public static final StandardAlgebra standardAlgebra() {
        if (standardAlgebra == null) {
            standardAlgebra = (StandardAlgebra)NumberAlgebra.registeredAlgebra(new StandardAlgebra());
        }
        return standardAlgebra;
    }

    public static final MaxMinAlgebra maxMinAlgebra() {
        if (maxMinAlgebra == null) {
            maxMinAlgebra = (MaxMinAlgebra)NumberAlgebra.registeredAlgebra(new MaxMinAlgebra());
        }
        return maxMinAlgebra;
    }

    public static final NumberAlgebra currentAlgebra() {
        if (currentAlgebra == null) {
            currentAlgebra = NumberAlgebra.standardAlgebra();
        }
        return currentAlgebra;
    }

    public static final void setCurrentAlgebra(NumberAlgebra numberAlgebra) {
        currentAlgebra = NumberAlgebra.registeredAlgebra(numberAlgebra);
    }

    public static final NumberAlgebra getCurrentAlgebra() {
        if (currentAlgebra == null) {
            throw new RuntimeException("There is no NumberAlgebra currently set.");
        }
        return currentAlgebra;
    }

    public static final void setStandardAlgebra() {
        currentAlgebra = NumberAlgebra.standardAlgebra();
    }

    public static final void setMaxMinAlgebra() {
        currentAlgebra = NumberAlgebra.maxMinAlgebra();
    }

    public static final NumberAlgebra registeredAlgebra(NumberAlgebra numberAlgebra) {
        String string = numberAlgebra.toString().intern();
        NumberAlgebra numberAlgebra2 = (NumberAlgebra)algebras.get(string);
        if (numberAlgebra2 != null) {
            return numberAlgebra2;
        }
        algebras.put(string, numberAlgebra);
        System.err.println("*** Registering new algebra: " + string);
        return numberAlgebra;
    }

    public static final void showRegisteredAlgebras() {
        System.out.println("\tCurrently registered number algebras:\n");
        Iterator iterator = algebras.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.println("\t" + iterator.next());
        }
        System.out.println();
    }

    static {
        algebras = new HashMap();
    }
}

