/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.base;

import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;
import hlt.osf.base.AndSortExpression;
import hlt.osf.base.Feature;
import hlt.osf.base.OsfExpression;
import hlt.osf.base.SortExpression;
import hlt.osf.base.SymbolSortExpression;
import hlt.osf.base.Tag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class PsiTerm
extends OsfExpression {
    private Tag _tag;
    private SortExpression _sort;
    private ArrayList _positions;
    private HashMap _features;
    private static boolean _evalSorts = false;

    public PsiTerm() {
        this._sort = new SymbolSortExpression("@");
    }

    public PsiTerm(Tag tag) {
        this.setTag(tag);
    }

    public PsiTerm(String string) {
        this._sort = new SymbolSortExpression(string);
    }

    public PsiTerm(SortExpression sortExpression) {
        this._sort = sortExpression;
    }

    public Tag tag() {
        return this._tag;
    }

    public PsiTerm deref() {
        return this._tag.deref().term();
    }

    public PsiTerm setTag(Tag tag) {
        this._tag = tag;
        tag.setTerm(this);
        return this;
    }

    public SortExpression sort() {
        return this._sort;
    }

    public PsiTerm setSort(SortExpression sortExpression) {
        this._sort = sortExpression;
        return this;
    }

    public ArrayList positions() {
        return this._positions;
    }

    public HashMap features() {
        return this._features;
    }

    public int positionArity() {
        return this._positions.size();
    }

    public int contiguousArity() {
        int n = this.positionArity();
        for (int i = 1; i <= n; ++i) {
            if (this._positions.get(i - 1) != null) continue;
            return i;
        }
        return n;
    }

    public PsiTerm getSubterm(int n) {
        if (this._positions == null || n > this._positions.size()) {
            return null;
        }
        return (PsiTerm)this._positions.get(n - 1);
    }

    public void setSubterm(int n, PsiTerm psiTerm) {
        if (this._positions == null) {
            this._positions = new ArrayList(n);
        }
        this._positions.secureSet(n - 1, psiTerm);
    }

    public PsiTerm getSubterm(Feature feature) {
        if (this._features == null || this._features.isEmpty()) {
            return null;
        }
        return (PsiTerm)this._features.get(feature);
    }

    public void setSubterm(Feature feature, PsiTerm psiTerm) {
        if (this._features == null) {
            this._features = new HashMap();
        }
        this._features.put(feature, psiTerm);
    }

    public void mergeSortWith(SortExpression sortExpression) {
        if (this._sort.equals(sortExpression)) {
            return;
        }
        if (this._sort.isSymbol() && ((SymbolSortExpression)this._sort).sort().isTop()) {
            this._sort = sortExpression;
        } else if (!sortExpression.isSymbol() || !((SymbolSortExpression)sortExpression).sort().isTop()) {
            this._sort = new AndSortExpression(this._sort, sortExpression);
        }
    }

    public PsiTerm merge(PsiTerm psiTerm) {
        PsiTerm psiTerm2;
        PsiTerm psiTerm3;
        if (this == psiTerm) {
            return this;
        }
        psiTerm.tag().bind(this._tag);
        this.mergeSortWith(psiTerm.sort());
        if (this._features == null) {
            this._features = psiTerm.features();
        } else if (psiTerm.features() != null) {
            for (Feature feature : psiTerm.features().keySet()) {
                psiTerm3 = this.getSubterm(feature);
                psiTerm2 = psiTerm.getSubterm(feature);
                if (psiTerm3 == null) {
                    if (psiTerm2 == null) continue;
                    this._features.put(feature, psiTerm2.deref());
                    continue;
                }
                if (psiTerm2 == null) continue;
                this._features.put(feature, psiTerm3.deref().merge(psiTerm2.deref()));
            }
        }
        if (this._positions == null) {
            this._positions = psiTerm.positions();
        } else if (psiTerm.positions() != null) {
            int n = Math.max(this.positionArity(), psiTerm.positionArity());
            for (int i = 1; i <= n; ++i) {
                psiTerm3 = this.getSubterm(i);
                psiTerm2 = psiTerm.getSubterm(i);
                if (psiTerm3 == null) {
                    if (psiTerm2 == null) continue;
                    this.setSubterm(i, psiTerm2.deref());
                    continue;
                }
                if (psiTerm2 == null) continue;
                this.setSubterm(i, psiTerm3.deref().merge(psiTerm2.deref()));
            }
        }
        return this;
    }

    public String displayForm(int n) {
        return this.deref().prettyPrint(n, new HashSet()).toString();
    }

    @Override
    public String displayForm() {
        return this.displayForm(0);
    }

    public static boolean evalSorts() {
        return _evalSorts;
    }

    public static void evaluateSorts(boolean bl) {
        _evalSorts = bl;
    }

    public static void toggleSortEvaluation() {
        _evalSorts = !_evalSorts;
    }

    public StringBuffer prettyPrint(int n, HashSet hashSet) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (hashSet.contains(this._tag)) {
            stringBuffer.append(this._tag.name());
            return stringBuffer;
        }
        Object object2 = object = _evalSorts ? this._sort.maxLowerBound() : this._sort.displayForm();
        if (this._tag.isShared()) {
            if (object == "@" && this._positions == null && this._features == null) {
                stringBuffer.append(this._tag.name());
                return stringBuffer;
            }
            object = this._tag.name() + " : " + (String)object;
            n += this._tag.name().length() + 3;
        }
        stringBuffer.append((String)object);
        hashSet.add(this._tag);
        if (this._positions != null || this._features != null) {
            Object object3;
            String string = Misc.repeat(n, ' ');
            stringBuffer.append("\n" + string + "( ");
            if (this._positions != null) {
                int n2;
                for (n2 = 1; n2 <= this.positionArity() && (object3 = this.getSubterm(n2)) != null; ++n2) {
                    stringBuffer.append(((PsiTerm)object3).deref().prettyPrint(n + 2, hashSet));
                    stringBuffer.append('\n');
                    if (n2 >= this.positionArity() && this._features == null) continue;
                    stringBuffer.append(string + ", ");
                }
                while (n2 <= this.positionArity()) {
                    object3 = this.getSubterm(n2);
                    if (object3 != null) {
                        object3 = ((PsiTerm)object3).deref();
                        stringBuffer.append(n2 + " => ");
                        stringBuffer.append(((PsiTerm)object3).prettyPrint(n + Misc.numWidth(n2) + 6, hashSet));
                        stringBuffer.append('\n');
                        if (n2 < this.positionArity() || this._features != null) {
                            stringBuffer.append(string + ", ");
                        }
                    }
                    ++n2;
                }
            }
            if (this._features != null) {
                Iterator iterator = this._features.keySet().iterator();
                while (iterator.hasNext()) {
                    object3 = (Feature)iterator.next();
                    PsiTerm psiTerm = this.getSubterm((Feature)object3).deref();
                    stringBuffer.append(((Feature)object3).name() + " => ");
                    stringBuffer.append(psiTerm.prettyPrint(n + ((Feature)object3).name().length() + 6, hashSet));
                    stringBuffer.append('\n');
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(string + ", ");
                }
            }
            stringBuffer.append(string + ")");
        }
        return stringBuffer;
    }
}

