/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.base;

import hlt.language.util.Comparable;
import hlt.osf.exec.Context;
import hlt.osf.exec.LockedCodeArrayException;
import hlt.osf.exec.Taxonomy;
import hlt.osf.util.BitCode;
import hlt.osf.util.Decoded;
import java.util.HashSet;

public class Sort
implements Comparable {
    private Context _context;
    private int _index;
    private String _name;
    private BitCode _bitcode;
    private Decoded _decoded;
    private static int _BITCODESIZE;
    private static Sort _TOP;
    private static Sort _BOTTOM;
    private HashSet _parents = new HashSet();
    private HashSet _children = new HashSet();
    boolean minimal = true;
    boolean maximal = true;
    private int _height = -1;

    public Context context() {
        return this._context;
    }

    public Sort setContext(Context context) {
        this._context = context;
        return this;
    }

    public byte type() {
        Sort sort = this;
        return sort._context.SYM();
    }

    public int index() {
        return this._index;
    }

    public Sort setIndex(int n) {
        this._index = n;
        return this;
    }

    public String name() {
        return this._name;
    }

    public Sort setName(String string) {
        this._name = string.intern();
        return this;
    }

    public BitCode bitcode() {
        return this._bitcode;
    }

    public Sort setBitcode(BitCode bitCode) {
        this._bitcode = bitCode;
        return this;
    }

    public Sort(String string) {
        this.setName(string);
    }

    public Sort(int n, String string) {
        this.setIndex(n);
        this.setName(string);
    }

    public Sort(int n, String string, BitCode bitCode) {
        this.setIndex(n);
        this.setName(string);
        this.setBitcode(bitCode);
    }

    public Sort(String string, Context context) {
        this.setName(string);
        this.setContext(context);
    }

    public boolean isSubsortOf(Sort sort) throws LockedCodeArrayException {
        if (this._bitcode == null) {
            throw new LockedCodeArrayException("Cannot compare a non-encoded sort");
        }
        return this._bitcode.isContainedIn(sort.bitcode());
    }

    public boolean isStrictSubsortOf(Sort sort) throws LockedCodeArrayException {
        if (this._bitcode == null) {
            throw new LockedCodeArrayException("Cannot compare a non-encoded sort");
        }
        return this._bitcode.isStrictlyContainedIn(sort.bitcode());
    }

    public boolean isRelatedTo(Sort sort) throws LockedCodeArrayException {
        if (this._bitcode == null) {
            throw new LockedCodeArrayException("Cannot compare a non-encoded sort");
        }
        return this._bitcode.isRelatedTo(sort.bitcode());
    }

    public boolean isUnrelatedTo(Sort sort) throws LockedCodeArrayException {
        if (this._bitcode == null) {
            throw new LockedCodeArrayException("Cannot compare a non-encoded sort");
        }
        return this._bitcode.isUnrelatedTo(sort.bitcode());
    }

    public Decoded decoded() {
        return this._decoded;
    }

    public Sort setDecoded(Decoded decoded) throws LockedCodeArrayException {
        if (decoded == null) {
            throw new LockedCodeArrayException("Attempt to set a sort's Decoded form to null");
        }
        this._decoded = decoded;
        return this;
    }

    public static int codeSize() throws LockedCodeArrayException {
        if (!Taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Attempt to access code size for a non-encoded taxonomy");
        }
        return _BITCODESIZE;
    }

    public static void setCodeSize(int n) throws LockedCodeArrayException {
        if (Taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Cannot change the sort code size for an encoded taxonomy");
        }
        _BITCODESIZE = n;
    }

    public static Sort top() {
        return _TOP;
    }

    public boolean isTop() {
        return this == _TOP;
    }

    public static Sort bottom() {
        return _BOTTOM;
    }

    public boolean isBottom() {
        return this == _BOTTOM;
    }

    public HashSet parents() {
        return this._parents;
    }

    public boolean addParent(Sort sort) {
        return this._parents.add(sort);
    }

    public boolean removeParent(Sort sort) {
        return this._parents.remove(sort);
    }

    public HashSet children() {
        return this._children;
    }

    public boolean addChild(Sort sort) {
        return this._children.add(sort);
    }

    public boolean removeChild(Sort sort) {
        return this._children.remove(sort);
    }

    public boolean addIsaDeclaration(Sort sort) {
        boolean bl = this.addParent(sort);
        boolean bl2 = sort.addChild(this);
        if (this.minimal) {
            _BOTTOM.addParent(this);
            this.addChild(_BOTTOM);
        }
        if (this.maximal) {
            this.maximal = false;
            _TOP.removeChild(this);
            this.removeParent(_TOP);
        }
        if (sort.maximal) {
            _TOP.addChild(sort);
            sort.addParent(_TOP);
        }
        if (sort.minimal) {
            sort.minimal = false;
            _BOTTOM.removeParent(sort);
            sort.removeChild(_BOTTOM);
        }
        return bl && bl2;
    }

    public int height() throws LockedCodeArrayException {
        if (!Taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Can't compute sort heights in a non-encoded taxonomy");
        }
        if (this._height != -1) {
            return this._height;
        }
        this._height = this._context.taxonomy().computeHeight(this);
        return this._height;
    }

    public Sort setHeight(int n) {
        this._height = n;
        return this;
    }

    public void resetHeight() {
        this._height = -1;
    }

    public int numberOfDescendants() {
        return this._bitcode.cardinality() - 1;
    }

    public HashSet descendants(Taxonomy taxonomy) throws LockedCodeArrayException {
        return this.decoded().descendants(taxonomy);
    }

    public HashSet ancestors(Taxonomy taxonomy) throws LockedCodeArrayException {
        return this.decoded().ancestors(taxonomy);
    }

    @Override
    public boolean lessThan(Comparable comparable) {
        return this.precedes((Sort)comparable);
    }

    public boolean precedes(Sort sort) {
        if (this._bitcode.isStrictlyContainedIn(sort.bitcode())) {
            return true;
        }
        if (this._bitcode.equals(sort.bitcode())) {
            return this._index < sort.index();
        }
        if (!sort.bitcode().isContainedIn(this._bitcode)) {
            int n;
            int n2 = this._bitcode.cardinality();
            if (n2 == (n = sort.bitcode().cardinality())) {
                int n3 = this._bitcode.nextSetBit(0);
                int n4 = sort.bitcode().nextSetBit(0);
                while (n3 == n4) {
                    n3 = this._bitcode.nextSetBit(n3 + 1);
                    n4 = sort.bitcode().nextSetBit(n4 + 1);
                }
                return n3 < n4;
            }
            return n2 < n;
        }
        return false;
    }

    public boolean equals(Sort sort) {
        return this._name == sort.name();
    }

    public Sort lock() {
        this._bitcode.lock();
        return this;
    }

    public Sort unlock() {
        this._bitcode.unlock();
        return this;
    }

    public boolean isLocked() {
        return this._bitcode.isLocked();
    }

    public String toString() {
        return this._name;
    }

    static {
        _TOP = new Sort(0, "@", new BitCode().lock());
        _BOTTOM = new Sort(-1, "{}", new BitCode().lock()).setHeight(0);
    }
}

