/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.base;

import hlt.osf.base.OsfExpression;
import hlt.osf.exec.Context;
import hlt.osf.util.BitCode;
import hlt.osf.util.Decoded;
import java.util.HashSet;
import java.util.Iterator;

public abstract class SortExpression
extends OsfExpression {
    private BitCode _bitcode;
    private Decoded _decoded;
    private boolean _isParenthesized = false;

    public abstract byte type();

    public boolean isConstant() {
        return this.type() == Context.CON();
    }

    public boolean isSymbol() {
        return this.type() == Context.SYM();
    }

    public boolean isDisjunction() {
        return this.type() == Context.DIS();
    }

    public boolean isNot() {
        return this.type() == Context.NOT();
    }

    public boolean isAnd() {
        return this.type() == Context.AND();
    }

    public boolean isOr() {
        return this.type() == Context.OR();
    }

    public boolean isButnot() {
        return this.type() == Context.BNT();
    }

    public BitCode bitcode() {
        return this._bitcode == null ? (this._bitcode = this._context.evaluate(this)) : this._bitcode;
    }

    public String maxLowerBound() {
        Decoded decoded = this.decoded();
        if (decoded.isSort()) {
            return decoded.sort().toString();
        }
        int n = 0;
        HashSet hashSet = decoded.glbs();
        StringBuffer stringBuffer = new StringBuffer("{ ");
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                if (++n == Decoded.enumSize()) {
                    stringBuffer.append("...");
                    break;
                }
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(" ; ");
            }
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public Decoded decoded() {
        return this._decoded == null ? (this._decoded = this._context.decode(this.bitcode())) : this._decoded;
    }

    public boolean isParenthesized() {
        return this._isParenthesized;
    }

    public SortExpression setParenthesized(boolean bl) {
        this._isParenthesized = bl;
        return this;
    }

    public String toString() {
        return this.displayForm();
    }
}

