/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.base;

import hlt.osf.base.PsiTerm;
import java.util.HashMap;
import java.util.Iterator;

public class Tag {
    private static int _tagNumber = 0;
    private static HashMap _knownTags = new HashMap();
    private Tag _ref = this;
    private boolean _isShared = false;
    private PsiTerm _term = null;
    private String _name;

    public static String newTagName() {
        String string;
        if (_knownTags.get(string = ("#_" + _tagNumber++).intern()) != null) {
            return Tag.newTagName();
        }
        return string;
    }

    public static void clearKnownTags() {
        _knownTags.clear();
        _tagNumber = 0;
    }

    public static void tallyTags() {
        if (!_knownTags.isEmpty()) {
            System.out.println("----------");
            System.out.println("Known Tags:");
            System.out.println("----------");
            Iterator iterator = _knownTags.values().iterator();
            while (iterator.hasNext()) {
                Tag tag;
                System.out.println(tag + ((tag = (Tag)iterator.next()).isShared() ? "\t(shared)" : ""));
            }
            System.out.println("----------");
        }
    }

    public static Tag getTag(String string) {
        Tag tag = null;
        if (string == null) {
            tag = new Tag();
            _knownTags.put(tag.name(), tag);
            return tag;
        }
        tag = (Tag)_knownTags.get(string = string.intern());
        if (tag == null) {
            tag = new Tag(string);
            _knownTags.put(tag.name(), tag);
        }
        return tag;
    }

    public static Tag newTag() {
        return Tag.getTag(null);
    }

    private Tag() {
        this._name = Tag.newTagName();
    }

    private Tag(String string) {
        this.setName(string);
    }

    public Tag ref() {
        return this._ref;
    }

    public Tag deref() {
        Tag tag;
        for (tag = this._ref; tag.ref() != tag; tag = tag.ref()) {
        }
        return tag;
    }

    public Tag bind(Tag tag) {
        if (this._isShared) {
            tag.markAsShared();
        } else if (tag.isShared()) {
            this.markAsShared();
        }
        this._ref = tag;
        return this;
    }

    public boolean isBound() {
        return this._ref != this;
    }

    public boolean isUnbound() {
        return this._ref == this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public Tag markAsShared() {
        this._isShared = true;
        return this;
    }

    public PsiTerm term() {
        return this._term;
    }

    public Tag setTerm(PsiTerm psiTerm) {
        this._term = psiTerm;
        return this;
    }

    public boolean isFree() {
        return this._term == null;
    }

    public String name() {
        return this._name == null ? (this._name = Tag.newTagName()) : this._name;
    }

    public Tag setName(String string) {
        this._name = string == null ? Tag.newTagName() : ((String)(string.charAt(0) == '#' ? string : "#" + string)).intern();
        return this;
    }

    public String toString() {
        return this.name();
    }

    public int hashCode() {
        return this.name().hashCode();
    }
}

