/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.exec;

import hlt.language.tools.Debug;
import hlt.language.util.ArrayList;
import hlt.language.util.Error;
import hlt.language.util.Locatable;
import hlt.language.util.Stack;
import hlt.osf.base.AndSortExpression;
import hlt.osf.base.ButnotSortExpression;
import hlt.osf.base.DisjunctiveSort;
import hlt.osf.base.NotSortExpression;
import hlt.osf.base.OrSortExpression;
import hlt.osf.base.Sort;
import hlt.osf.base.SortExpression;
import hlt.osf.base.SymbolSortExpression;
import hlt.osf.exec.AnomalousSituationException;
import hlt.osf.exec.LockedCodeArrayException;
import hlt.osf.exec.Taxonomy;
import hlt.osf.exec.UndefinedSymbolException;
import hlt.osf.io.DisplayFormManager;
import hlt.osf.io.DisplayManager;
import hlt.osf.util.BitCode;
import hlt.osf.util.Decoded;
import hlt.osf.util.ErrorLogger;
import java.util.HashMap;

public class Context {
    private int _SORT_CODE_ARRAY_SIZE = 1000000;
    private Taxonomy _taxonomy = new Taxonomy(this._SORT_CODE_ARRAY_SIZE);
    private ErrorLogger _errorLogger = new ErrorLogger();
    private int _NAMED_SORTS_TABLE_SIZE = 2 * this._SORT_CODE_ARRAY_SIZE;
    private HashMap _namedSorts = new HashMap(this._NAMED_SORTS_TABLE_SIZE);
    private int _CODE_CACHE_TABLE_SIZE = 3 * this._SORT_CODE_ARRAY_SIZE;
    private HashMap _codeCache = new HashMap(this._CODE_CACHE_TABLE_SIZE);
    private DisplayManager _displayManager = new DisplayManager();
    private static final byte _CON = 0;
    private static final byte _SYM = 1;
    private static final byte _DIS = 2;
    private static final byte _NOT = 3;
    private static final byte _AND = 4;
    private static final byte _OR = 5;
    private static final byte _BNT = 6;
    private static final byte _BAD = 7;
    private static final Byte _NOT_OP = 3;
    private static final Byte _AND_OP = 4;
    private static final Byte _OR_OP = 5;
    private Stack _exprStack = new Stack();
    private Stack _evalStack = new Stack();
    private SortExpression _lastExpression;
    private static boolean _isTiming = false;
    private static boolean _isTracing = false;
    private static int _NUM_OF_CODES_COPIED;
    private static int _CODE_COPIES_SO_FAR;
    static boolean negativeQuery;

    public Taxonomy taxonomy() {
        return this._taxonomy;
    }

    public Context() {
        this._taxonomy.setContext(this);
    }

    public Context(int n) {
        this(n, 2.0f, 3.0f);
    }

    public Context(int n, float f, float f2) {
        this();
        this._SORT_CODE_ARRAY_SIZE = n;
        this._NAMED_SORTS_TABLE_SIZE = Math.round(f * (float)n);
        this._CODE_CACHE_TABLE_SIZE = Math.round(f2 * (float)n);
    }

    public ErrorLogger errorLogger() {
        return this._errorLogger;
    }

    public static Sort top() throws LockedCodeArrayException {
        return Sort.top();
    }

    public static Sort bottom() throws LockedCodeArrayException {
        return Sort.bottom();
    }

    public void reset() {
        this._taxonomy.reset(Taxonomy.builtins.size());
        this._namedSorts.clear();
        this._codeCache.clear();
        int n = Taxonomy.builtins.size();
        while (n-- > 0) {
            Sort sort = (Sort)this._taxonomy.get(n);
            this._namedSorts.put(sort.name(), sort);
        }
        this._lastExpression = null;
        this._taxonomy.unlock();
    }

    public HashMap namedSorts() {
        return this._namedSorts;
    }

    public HashMap codeCache() {
        return this._codeCache;
    }

    public Sort getSort(String string) throws UndefinedSymbolException {
        String string2 = string.intern();
        if (string2 == "@") {
            return Context.top();
        }
        if (string2 == "{}") {
            return Context.bottom();
        }
        Sort sort = (Sort)this._namedSorts.get(string2);
        if (sort == null) {
            Context context = this;
            if (context._taxonomy.isLocked()) {
                throw new UndefinedSymbolException("Undefined sort symbol: " + string);
            }
            BitCode bitCode = new BitCode();
            int n = this._taxonomy.size();
            bitCode.set(n);
            sort = new Sort(n, string2, bitCode);
            this._taxonomy.add(sort);
            this._namedSorts.put(string2, sort);
        }
        return sort.setContext(this);
    }

    private void _checkDeclaredSort(String string) {
        String string2 = string.intern();
        Sort sort = (Sort)this._namedSorts.get(string2);
        if (sort == null) {
            BitCode bitCode = new BitCode();
            int n = this._taxonomy.size();
            bitCode.set(n);
            sort = new Sort(n, string2, bitCode);
            Sort.top().addChild(sort);
            sort.addParent(Sort.top());
            Sort.bottom().addParent(sort);
            sort.addChild(Sort.bottom());
            this._taxonomy.add(sort);
            this._namedSorts.put(string2, sort);
            sort.setContext(this);
        }
    }

    public BitCode getSortCode(String string) throws LockedCodeArrayException, UndefinedSymbolException {
        Context context = this;
        if (!context._taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Attempt to perform an operation requiring prior sort encoding");
        }
        if (string == "@") {
            return Context.top().bitcode();
        }
        if (string == "{}") {
            return Context.bottom().bitcode();
        }
        Sort sort = (Sort)this._namedSorts.get(string);
        if (sort == null) {
            throw new UndefinedSymbolException("Undefined sort symbol: " + string);
        }
        return sort.bitcode();
    }

    public String decodedString(BitCode bitCode) {
        DisplayFormManager displayFormManager = this._displayManager.displayFormManager();
        int n = bitCode.cardinality();
        if (n == 0) {
            return displayFormManager.displayBottomForm();
        }
        if (n == this._taxonomy.size()) {
            return displayFormManager.displayTopForm();
        }
        Decoded decoded = this.decode(bitCode);
        if (decoded.isSort()) {
            return displayFormManager.displaySortForm(decoded.sort());
        }
        return displayFormManager.displayForm(decoded.glbs(), false);
    }

    public Decoded decode(BitCode bitCode) {
        long l = System.currentTimeMillis();
        Decoded decoded = (Decoded)this._codeCache.get(bitCode);
        if (decoded == null) {
            decoded = this._taxonomy.decode(bitCode);
            this._codeCache.put(bitCode, decoded);
        }
        l = System.currentTimeMillis() - l;
        if (_isTiming) {
            System.out.println("*** Decoding time = " + l + " ms");
        }
        return decoded;
    }

    public void declareIsa(String string, String string2, Locatable locatable) {
        Sort sort;
        String string3 = locatable.locationString();
        Context context = this;
        if (context._taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Attempt to modify an already encoded sort taxonomy - in " + string3);
        }
        if (string == "{}") {
            throw new AnomalousSituationException("Cannot declare a supersort of {} - in " + string3);
        }
        if (string2 == "{}") {
            throw new AnomalousSituationException("Cannot declare a subsort of {} - in " + string3);
        }
        if (string == "@") {
            throw new AnomalousSituationException("Cannot declare @ as a subsort - in " + string3);
        }
        if (string2 == "@") {
            this._checkDeclaredSort(string);
            return;
        }
        if (string == string2) {
            this._errorLogger.recordError(new Error().makeWarning().setLabel("Warning: ").setMsg("reflexive subsort declaration: " + string + " <| " + string2 + " (ignored)").setExtent(locatable));
            return;
        }
        Sort sort2 = this.getSort(string);
        if (!sort2.addIsaDeclaration(sort = this.getSort(string2))) {
            this._errorLogger.recordError(new Error().makeWarning().setLabel("Warning: ").setMsg("redundant subsort declaration: " + string + " <| " + string2 + " (ignored)").setExtent(locatable));
        }
        sort.bitcode().set(sort2.index());
    }

    public void encodeSorts() throws AnomalousSituationException {
        this._taxonomy.encodeSorts();
    }

    public void encodeSorts(int n, int n2) throws AnomalousSituationException {
        this._taxonomy.encodeSorts(n, n2);
    }

    public DisplayManager displayManager() {
        return this._displayManager;
    }

    public void setDisplayManager(DisplayManager displayManager) {
        this._displayManager = displayManager;
    }

    public static final byte CON() {
        return 0;
    }

    public static final byte SYM() {
        return 1;
    }

    public static final byte DIS() {
        return 2;
    }

    public static final byte NOT() {
        return 3;
    }

    public static final byte AND() {
        return 4;
    }

    public static final byte OR() {
        return 5;
    }

    public static final byte BNT() {
        return 6;
    }

    public SortExpression lastExpression() throws LockedCodeArrayException, AnomalousSituationException {
        Context context = this;
        if (!context._taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Attempt to perform an operation requiring prior sort encoding");
        }
        if (this._lastExpression == null) {
            throw new AnomalousSituationException("No expression has been evaluated yet");
        }
        return this._lastExpression;
    }

    public BitCode evaluate(SortExpression sortExpression) throws LockedCodeArrayException {
        Context context = this;
        if (!context._taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Attempt to evaluate a sort expression with a non-encoded sort taxonomy");
        }
        this._exprStack.clear();
        this._evalStack.clear();
        this._lastExpression = sortExpression;
        long l = System.nanoTime();
        System.err.println(">>> Expression to be compiled and evaluated: " + sortExpression);
        this._compile(sortExpression);
        l = System.nanoTime() - l;
        long l2 = System.nanoTime();
        BitCode bitCode = this._evaluate();
        l2 = System.nanoTime() - l2;
        if (_isTiming) {
            System.out.println("*** Expression compilation time = " + (double)l / 1000000.0 + " ms");
            System.out.println("*** Expression evaluation time = " + (double)l2 / 1000000.0 + " ms");
            System.out.println("*** Expression processing time = " + (double)(l + l2) / 1000000.0 + " ms");
        }
        return bitCode;
    }

    public static void toggleTiming() {
        _isTiming = !_isTiming;
    }

    public static boolean isTiming() {
        return _isTiming;
    }

    public static void toggleTracing() {
        _isTracing = !_isTracing;
    }

    public static boolean isTracing() {
        return _isTracing;
    }

    private void _showStack(Stack stack) {
        int n = stack.size();
        while (n-- > 0) {
            this._printStackElt(stack.get(n));
        }
    }

    private void _printStackElt(Object object) {
        if (object instanceof Byte) {
            System.err.println(this._opToString((Byte)object));
        } else {
            System.err.println(this.decodedString((BitCode)object));
        }
    }

    private void _showSortStack(Stack stack) {
        int n = stack.size();
        while (n-- > 0) {
            this._printSortStackElt((BitCode)stack.get(n));
        }
    }

    private void _printSortStackElt(BitCode bitCode) {
        System.err.println("code = " + bitCode + "\tmaximal subsort = " + this.decodedString(bitCode));
        System.err.println("\tancestors = " + bitCode.decoded().ancestors(this._taxonomy));
        System.err.println("\tlubs = " + bitCode.decoded().lubs());
        Sort sort = bitCode.decoded().sort();
        System.err.println("\tsort = " + (sort == null ? "" : sort));
        System.err.println("\tglbs = " + bitCode.decoded().glbs());
        System.err.println("\tdescendants = " + bitCode.decoded().descendants(this._taxonomy));
    }

    private String _opToString(Byte by) {
        switch (by) {
            case 4: {
                return "AND";
            }
            case 5: {
                return "OR";
            }
            case 3: {
                return "NOT";
            }
        }
        return "UNKNOWN_OP";
    }

    private void _trace() {
        System.err.println("*****************");
        System.err.println("EVALUATION STACK:");
        System.err.println("*****************");
        this._showSortStack(this._evalStack);
        System.err.println();
        System.err.println("*****************");
        System.err.println("EXPRESSION STACK:");
        System.err.println("*****************");
        this._showStack(this._exprStack);
        if (_NUM_OF_CODES_COPIED != _CODE_COPIES_SO_FAR) {
            int n;
            System.err.println("\nMade " + n + " new code cop" + ((n = _NUM_OF_CODES_COPIED - _CODE_COPIES_SO_FAR) == 1 ? "y" : "ies"));
            _CODE_COPIES_SO_FAR = _NUM_OF_CODES_COPIED;
        }
        Debug.step();
    }

    public static void tallyCodeCopy() {
        ++_NUM_OF_CODES_COPIED;
    }

    private void _compile(SortExpression sortExpression) throws UndefinedSymbolException {
        System.err.println(">>> Compiling expression " + sortExpression);
        ArrayList arrayList = null;
        int n = 0;
        switch (sortExpression.type()) {
            case 1: {
                this._exprStack.push(this.getSortCode(((SymbolSortExpression)sortExpression).name()));
                return;
            }
            case 2: {
                arrayList = ((DisjunctiveSort)sortExpression).names();
                n = arrayList.size();
                if (n == 0) {
                    this._exprStack.push(Context.bottom().bitcode());
                    return;
                }
                int n2 = n;
                while (n2-- > 1) {
                    this._exprStack.push(_OR_OP);
                    this._exprStack.push(this.getSortCode((String)arrayList.get(n2)));
                }
                this._exprStack.push(this.getSortCode((String)arrayList.get(0)));
                return;
            }
            case 3: {
                this._exprStack.push(_NOT_OP);
                this._compile(((NotSortExpression)sortExpression).arg());
                return;
            }
            case 4: {
                this._exprStack.push(_AND_OP);
                this._compile(((AndSortExpression)sortExpression).rhs());
                this._compile(((AndSortExpression)sortExpression).lhs());
                return;
            }
            case 5: {
                this._exprStack.push(_OR_OP);
                this._compile(((OrSortExpression)sortExpression).rhs());
                this._compile(((OrSortExpression)sortExpression).lhs());
                return;
            }
            case 6: {
                this._exprStack.push(_AND_OP);
                this._exprStack.push(_NOT_OP);
                this._compile(((ButnotSortExpression)sortExpression).rhs());
                this._compile(((ButnotSortExpression)sortExpression).lhs());
                return;
            }
        }
    }

    private BitCode _evaluate() {
        System.err.println(">>> Evaluating the stack");
        Object object = null;
        BitCode bitCode = null;
        BitCode bitCode2 = null;
        if (_isTracing) {
            _NUM_OF_CODES_COPIED = 0;
            _CODE_COPIES_SO_FAR = 0;
        }
        while (!this._exprStack.empty()) {
            if (_isTracing) {
                this._trace();
            }
            if ((object = this._exprStack.pop()) instanceof BitCode) {
                this._evalStack.push(object);
                continue;
            }
            switch ((Byte)object) {
                case 3: {
                    bitCode = (BitCode)this._evalStack.pop();
                    this._evalStack.push(BitCode.not(bitCode));
                    negativeQuery = true;
                    if (!_isTracing) break;
                    System.err.println(">>> Setting negative query flag");
                    break;
                }
                case 4: {
                    bitCode = (BitCode)this._evalStack.pop();
                    bitCode2 = (BitCode)this._evalStack.pop();
                    this._evalStack.push(BitCode.and(bitCode, bitCode2));
                    break;
                }
                case 5: {
                    bitCode = (BitCode)this._evalStack.pop();
                    bitCode2 = (BitCode)this._evalStack.pop();
                    this._evalStack.push(BitCode.or(bitCode, bitCode2));
                }
            }
        }
        if (_isTracing) {
            this._trace();
            System.err.println("\nTotal number of code copying in this run: " + _NUM_OF_CODES_COPIED);
        }
        return ((BitCode)this._evalStack.pop()).lock();
    }

    static {
        negativeQuery = false;
    }
}

