/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.exec;

import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;
import hlt.language.util.IntArrayList;
import hlt.language.util.IntIterator;
import hlt.osf.base.Sort;
import hlt.osf.exec.AnomalousSituationException;
import hlt.osf.exec.Context;
import hlt.osf.exec.Contextable;
import hlt.osf.exec.CyclicSortOrderingException;
import hlt.osf.exec.LockedCodeArrayException;
import hlt.osf.io.BadTokenException;
import hlt.osf.io.DisplayManager;
import hlt.osf.io.TaxonomyLoader;
import hlt.osf.util.BitCode;
import hlt.osf.util.Decoded;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;

public class Taxonomy
extends ArrayList
implements Contextable {
    private Context _context;
    private static boolean _isLocked = false;
    public static ArrayList builtins = new ArrayList();
    public static final Sort INTEGER = Taxonomy._newBuiltInSort("int");
    public static final Sort CHAR = Taxonomy._newBuiltInSort("char");
    public static final Sort FLOAT = Taxonomy._newBuiltInSort("float");
    public static final Sort STRING = Taxonomy._newBuiltInSort("string");
    public static final Sort BOOLEAN = Taxonomy._newBuiltInSort("boolean");
    IntArrayList layers = new IntArrayList();
    private ArrayList _cycles = new ArrayList();

    public Taxonomy() {
    }

    public Taxonomy(int n) {
        super(n);
    }

    public Taxonomy(Context context) {
        this();
        this._context = context;
    }

    public Taxonomy(int n, Context context) {
        this(n);
        this._context = context;
    }

    @Override
    public Context context() {
        return this._context;
    }

    @Override
    public Taxonomy setContext(Context context) {
        this._context = context;
        for (int i = 0; i < builtins.size(); ++i) {
            Sort sort = (Sort)builtins.get(i);
            this.add(sort);
            sort.setContext(this._context);
            this._context.namedSorts().put(sort.name(), sort);
            this._context.codeCache().put(sort.bitcode(), sort.setDecoded(new Decoded(sort)).decoded());
        }
        return this;
    }

    public Sort getSort(int n) {
        return (Sort)this.get(n);
    }

    public static boolean isLocked() {
        return _isLocked;
    }

    private void _lock() {
        _isLocked = true;
    }

    public void unlock() {
        _isLocked = false;
    }

    private static Sort _newBuiltInSort(String string) {
        BitCode bitCode = new BitCode();
        bitCode.set(builtins.size());
        Sort sort = new Sort(builtins.size(), string, bitCode);
        Sort.top().addChild(sort);
        sort.addParent(Sort.top());
        Sort.bottom().addParent(sort);
        sort.addChild(Sort.bottom());
        builtins.add(sort);
        return sort.lock();
    }

    public void encodeSorts() throws AnomalousSituationException {
        this.encodeSorts(builtins.size(), this.size() - 1);
        this._initialize();
    }

    public void encodeSorts(int n, int n2) throws AnomalousSituationException, LockedCodeArrayException, CyclicSortOrderingException {
        if (n > n2) {
            throw new AnomalousSituationException("No sorts have been defined to encode");
        }
        if (_isLocked) {
            throw new LockedCodeArrayException("Unable to encode an already encoded sort taxonomy");
        }
        System.out.println("*** Performing transitive closure...");
        long l = System.currentTimeMillis();
        this._bottomUpClosure();
        l = System.currentTimeMillis() - l;
        System.out.println("*** Transitive closure processing time = " + l + " ms");
        System.out.println("*** Performing consistency check of the taxonomy...");
        l = System.currentTimeMillis();
        this._checkCodes(n, n2);
        l = System.currentTimeMillis() - l;
        System.out.println("*** Code consistency check processing time = " + l + " ms");
        System.out.println("*** Committing all sorts...");
        l = System.currentTimeMillis();
        this._commitAllSorts(n, n2);
        l = System.currentTimeMillis() - l;
        System.out.println("*** Sort commitment processing time = " + l + " ms");
    }

    private void _initialize() throws AnomalousSituationException {
        Sort.setCodeSize(this.size() + 1);
        this._lock();
        this.add(Sort.top());
        Sort.top().setIndex(this.size() - 1).bitcode().set(0, this.size());
        Sort.bottom().setContext(this._context);
        Sort.top().setContext(this._context);
        Sort.bottom().setDecoded(Decoded.bottom());
        Sort.top().setDecoded(Decoded.top());
        this._context.namedSorts().put(Sort.top().name(), Sort.top());
        this._context.codeCache().put(Sort.top().bitcode(), Decoded.top());
        this._context.namedSorts().put(Sort.bottom().name(), Sort.bottom());
        this._context.codeCache().put(Sort.bottom().bitcode(), Decoded.bottom());
        for (int i = 0; i < builtins.size(); ++i) {
            Sort sort = this.getSort(i);
            this._context.namedSorts().put(sort.name(), sort);
            Decoded decoded = sort.decoded();
            this._context.codeCache().put(sort.bitcode(), decoded != null ? decoded : sort.setDecoded(new Decoded(sort)).decoded());
        }
    }

    void _checkCodes(int n, int n2) throws CyclicSortOrderingException {
        Sort sort;
        int n3;
        int n4;
        ArrayList arrayList = new ArrayList();
        for (n4 = n; n4 <= n2; ++n4) {
            Sort sort2 = this.getSort(n4);
            if (sort2.isLocked()) continue;
            arrayList.add(sort2);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        this.reset();
        n4 = arrayList.size() - 1;
        for (n3 = 0; n3 <= n4; ++n3) {
            sort = (Sort)arrayList.get(n3);
            sort.setIndex(n3);
            sort.bitcode().clear();
            sort.bitcode().set(n3);
            this.add(sort);
        }
        Sort.setCodeSize(this.size());
        for (n3 = 0; n3 <= n4; ++n3) {
            sort = this.getSort(n3);
            for (Sort sort3 : sort.parents()) {
                if (sort3.isLocked()) continue;
                sort3.bitcode().set(sort.index());
            }
        }
        this._transitiveClosure(0, n4);
        this._reorder(0, n4);
        throw new CyclicSortOrderingException(this._identifyCycles(0, n4));
    }

    private ArrayList _identifyCycles(int n, int n2) {
        this._cycles.clear();
        ArrayList arrayList = null;
        Sort sort = null;
        Sort sort2 = null;
        for (int i = n; i <= n2; ++i) {
            sort = this.getSort(i);
            if (sort2 != null && sort.bitcode().equals(sort2.bitcode())) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    arrayList.add(sort2.name());
                }
                arrayList.add(sort.name());
                continue;
            }
            sort2 = sort;
            if (arrayList == null) continue;
            this._cycles.add(arrayList);
            arrayList = null;
        }
        return this._cycles;
    }

    private void _bottomUpClosure() {
        HashSet hashSet = (HashSet)Sort.bottom().parents().clone();
        boolean bl = false;
        do {
            this.layers.add(hashSet.size());
            if (Context.isTracing()) {
                System.out.println("*** Layer " + this.layers.size() + " has " + hashSet.size() + " sorts");
            }
            this._encodeLayer(hashSet);
        } while (!(hashSet = this._nextLayer(hashSet)).isEmpty());
    }

    private void _encodeLayer(HashSet hashSet) {
        for (Sort sort : hashSet) {
            Iterator iterator = sort.children().iterator();
            while (iterator.hasNext()) {
                sort.bitcode().or(((Sort)iterator.next()).bitcode());
            }
            sort.lock();
        }
    }

    private HashSet _nextLayer(HashSet hashSet) {
        HashSet<Sort> hashSet2 = new HashSet<Sort>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            HashSet hashSet3 = ((Sort)iterator.next()).parents();
            for (Sort sort : hashSet3) {
                boolean bl = false;
                for (Sort sort2 : sort.children()) {
                    if (sort2.isLocked()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                hashSet2.add(sort);
            }
        }
        return hashSet2;
    }

    private void _transitiveClosure() {
        this._transitiveClosure(0, this.size() - 1);
    }

    private void _transitiveClosure(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            for (int j = n; j <= n2; ++j) {
                for (int k = n; k <= n2; ++k) {
                    Sort sort = this.getSort(j);
                    if (sort.bitcode().get(k)) continue;
                    sort.bitcode().set(k, sort.bitcode().get(i) && this.getSort(i).bitcode().get(k));
                }
            }
        }
    }

    private void _reorder() {
        Misc.sort(this);
    }

    private void _reorder(int n, int n2) {
        Misc.sort(this, n, n2);
    }

    private void _commitAllSorts(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._commitSort(i);
        }
    }

    private Sort _commitSort(int n) {
        Sort sort = this.getSort(n);
        this._context.namedSorts().put(sort.name(), sort);
        this._context.codeCache().put(sort.bitcode(), sort.setDecoded(new Decoded(sort)).decoded());
        return sort;
    }

    public void reset() {
        this.reset(0);
    }

    public void reset(int n) {
        this.clear(n);
        Sort.top().children().clear();
        Sort.bottom().parents().clear();
    }

    public Decoded decode(BitCode bitCode) {
        int n;
        if (!_isLocked) {
            throw new LockedCodeArrayException("Attempt to perform an operation requiring prior sort encoding");
        }
        BitCode bitCode2 = new BitCode();
        BitCode bitCode3 = bitCode.copy();
        HashSet hashSet = new HashSet(bitCode.size());
        Object object = BitCode.not(bitCode).iterator();
        while (object.hasNext()) {
            Sort sort;
            n = object.next();
            if (Context.negativeQuery) {
                sort = this.getSort(n);
                HashSet hashSet2 = this.getSort(n).ancestors(this);
                if (hashSet2 != null) {
                    hashSet.addAll(hashSet2);
                }
            }
            if (!bitCode.isStrictlyContainedIn((sort = this.getSort(n)).bitcode())) continue;
            boolean bl = true;
            IntIterator intIterator = bitCode2.iterator();
            while (intIterator.hasNext()) {
                Sort sort2 = this.getSort(intIterator.next());
                if (sort2.bitcode().isStrictlyContainedIn(sort.bitcode())) {
                    bl = false;
                    break;
                }
                if (!sort.bitcode().isStrictlyContainedIn(sort2.bitcode())) continue;
                bitCode2.remove(sort2.index());
            }
            if (!bl) continue;
            bitCode2.add(n);
        }
        if (Context.negativeQuery) {
            for (Sort sort : hashSet) {
                bitCode3.clear(sort.index());
            }
            Context.negativeQuery = false;
        }
        object = bitCode3.iterator();
        while (object.hasNext()) {
            n = object.next();
            bitCode3.andNot(this.getSort(n).bitcode());
            bitCode3.set(n);
        }
        return new Decoded(bitCode, bitCode2.toHashSet(this), bitCode3.toHashSet(this));
    }

    public int computeHeight(Sort sort) throws LockedCodeArrayException {
        int n;
        if (!Taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Can't compute sort heights in a non-encoded taxonomy");
        }
        int n2 = 0;
        IntIterator intIterator = sort.bitcode().iterator();
        while (intIterator.hasNext() && (n = intIterator.next()) < this.size()) {
            if (n == sort.index()) continue;
            n2 = Math.max(n2, this.computeHeight(this.getSort(n)));
        }
        return 1 + n2;
    }

    public void showSortCodes() {
        this.showSortCodes(0, this.size() - 2);
    }

    public void showSortCodes(int n, int n2) {
        int n3 = Misc.numWidth(n2);
        DisplayManager displayManager = this._context.displayManager();
        displayManager.println(Misc.repeat(n3, ' ') + " " + Sort.top().bitcode() + " " + Sort.top().name());
        for (int i = n2; i >= n; --i) {
            Sort sort = this.getSort(i);
            displayManager.println(Misc.numberString(i, n3) + " " + sort.bitcode() + " " + sort.name());
        }
        displayManager.println(Misc.repeat(n3, ' ') + " " + Sort.bottom().bitcode() + " " + Sort.bottom().name());
    }

    public void save(String string) throws FileNotFoundException {
        int n;
        PrintStream printStream = new PrintStream(string);
        int n2 = this.size() - 1;
        printStream.println(n2);
        Sort sort = null;
        for (n = 0; n < n2; ++n) {
            sort = this.getSort(n);
            printStream.print(sort.name());
            printStream.print(" ");
            printStream.println(sort.bitcode().toSaveFormatString());
        }
        for (n = 0; n < n2; ++n) {
            sort = this.getSort(n);
            if (sort.parents().contains(Sort.top())) continue;
            printStream.print(n + " ");
            for (Sort sort2 : sort.parents()) {
                printStream.print(sort2.index() + " ");
            }
            printStream.println();
        }
        printStream.close();
    }

    public void load(String string) throws FileNotFoundException, IOException, BadTokenException {
        int n;
        TaxonomyLoader taxonomyLoader = new TaxonomyLoader(string);
        taxonomyLoader.nextToken();
        if (taxonomyLoader.tokenType() != -5) {
            taxonomyLoader.error();
        }
        int n2 = taxonomyLoader.intValue();
        this.ensureCapacity(n2 + 1);
        Sort.setCodeSize(n2 + 1);
        taxonomyLoader.nextToken();
        Sort sort = null;
        BitCode bitCode = null;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            taxonomyLoader.nextToken();
            if (taxonomyLoader.tokenType() != -4) {
                taxonomyLoader.error();
            }
            bitCode = new BitCode();
            sort = new Sort(n, taxonomyLoader.symbolValue(), bitCode).setContext(this._context);
            this.set(n, sort);
            taxonomyLoader.nextToken();
            while (true) {
                if (taxonomyLoader.tokenType() == 10) break;
                if (taxonomyLoader.tokenType() != -5) {
                    taxonomyLoader.error();
                }
                n3 = taxonomyLoader.intValue();
                taxonomyLoader.nextToken();
                if (taxonomyLoader.tokenType() != -5) {
                    taxonomyLoader.error();
                }
                bitCode.set(n3, taxonomyLoader.intValue());
                taxonomyLoader.nextToken();
            }
            this._commitSort(n);
        }
        while (true) {
            taxonomyLoader.nextToken();
            if (taxonomyLoader.eof()) break;
            if (taxonomyLoader.tokenType() != -5) {
                taxonomyLoader.error();
            }
            n = taxonomyLoader.intValue();
            sort = this.getSort(n);
            while (true) {
                taxonomyLoader.nextToken();
                if (taxonomyLoader.tokenType() == 10) break;
                if (taxonomyLoader.tokenType() != -5) {
                    taxonomyLoader.error();
                }
                sort.addIsaDeclaration(this.getSort(taxonomyLoader.intValue()));
            }
            sort.lock();
        }
        taxonomyLoader.close();
        this._initialize();
    }
}

