/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.io;

import hlt.language.util.ArrayList;
import hlt.language.util.IntIterator;
import hlt.osf.base.Sort;
import hlt.osf.exec.Taxonomy;
import hlt.osf.util.BitCode;
import hlt.osf.util.Decoded;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DisplayFormManager {
    private final HashMap _tags = new HashMap();

    public String displayBottomForm() {
        return Sort.bottom().toString();
    }

    public String displayTopForm() {
        return Sort.top().toString();
    }

    public final String displaySortForm(Sort sort) {
        return sort.toString();
    }

    public final String displayForm(Sort sort) {
        if (sort.isTop()) {
            return this.displayTopForm();
        }
        if (sort.isBottom()) {
            return this.displayBottomForm();
        }
        return this.displaySortForm(sort);
    }

    public final String displaySortsForm(Sort[] sortArray) {
        if (sortArray == null) {
            return "*null sort array*";
        }
        if (sortArray.length == 0) {
            return "*no sort*";
        }
        if (sortArray.length == 1) {
            return sortArray[0].toString();
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        int n = sortArray.length;
        while (n-- > 0) {
            stringBuilder.append(sortArray[n] + (n > 0 ? "; " : ""));
        }
        return stringBuilder.append("}").toString();
    }

    public final String displaySortsForm(ArrayList arrayList) {
        if (arrayList == null) {
            return "*null disjunctive sort*";
        }
        if (arrayList.isEmpty()) {
            return this.displayBottomForm();
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0).toString();
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next() + (iterator.hasNext() ? "; " : ""));
        }
        return stringBuilder.append("}").toString();
    }

    public final String displayForm(BitCode bitCode, Taxonomy taxonomy) {
        if (bitCode == null) {
            return "*null disjunctive sort*";
        }
        if (bitCode.isEmpty()) {
            return this.displayBottomForm();
        }
        if (bitCode.cardinality() == 1) {
            return taxonomy.get(bitCode.nextSetBit(0)).toString();
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        IntIterator intIterator = bitCode.iterator();
        while (intIterator.hasNext()) {
            stringBuilder.append(taxonomy.get(intIterator.next()) + (intIterator.hasNext() ? "; " : ""));
        }
        return stringBuilder.append("}").toString();
    }

    public final String displayForm(HashSet hashSet, boolean bl) {
        if (hashSet == null || hashSet.isEmpty()) {
            return bl ? "*EVERYTHING*" : "*NOTHING*";
        }
        if (hashSet.size() == 1) {
            return hashSet.iterator().next().toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = hashSet.contains(Sort.top()) ? hashSet.size() - 1 : hashSet.size();
        int n2 = 0;
        for (Sort sort : hashSet) {
            if (sort.isTop()) continue;
            if (n2++ > Decoded.enumSize()) {
                stringBuffer.append("... (" + n + " elements in total)");
                break;
            }
            stringBuffer.append(sort + " ");
        }
        return stringBuffer.toString();
    }

    public String quotedDisplayForm(double d) {
        return String.valueOf(d);
    }

    public String unquotedDisplayForm(double d) {
        return this.quotedDisplayForm(d);
    }

    public DisplayFormManager clearTags() {
        this._tags.clear();
        return this;
    }
}

