/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.io;

import hlt.language.io.StreamTokenizer;
import hlt.language.util.Location;
import hlt.language.util.Span;
import hlt.osf.io.BadTokenException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class TaxonomyLoader {
    private String _file;
    private FileReader _reader;
    private StreamTokenizer _st;
    private int _tokenType;
    private int _intValue;
    private String _symbolValue;
    private int _rank = -1;
    private boolean _eof = false;
    public static final byte EOF = -1;
    public static final byte EOL = 10;
    public static final byte WORD = -4;
    public static final byte NUMBER = -5;

    public final int tokenType() {
        return this._tokenType;
    }

    public final int intValue() {
        return this._intValue;
    }

    public final String symbolValue() {
        return this._symbolValue;
    }

    public final boolean eof() {
        return this._eof;
    }

    public TaxonomyLoader(String string) throws FileNotFoundException {
        this._file = string;
        this._reader = new FileReader(string);
        this.setReader(this._reader);
    }

    public final void setReader(Reader reader) {
        this._st = new StreamTokenizer(reader);
        this._st.eolIsSignificant(true);
        this._st.quoteChar(39);
        this._st.quoteChar(34);
        this._st.wordChars("-_@");
    }

    public final Reader getReader() {
        return this._reader;
    }

    public final int lineNumber() {
        return this._st.lineno();
    }

    public final Location tokenStart() {
        return this._st.tokenStart();
    }

    public final Location tokenEnd() {
        return this._st.tokenEnd();
    }

    public final void error() throws BadTokenException {
        throw new BadTokenException(new Span(this.tokenStart(), this.tokenEnd()).toString());
    }

    final void eol() {
        ++this._rank;
    }

    final void setEof() {
        this._eof = true;
    }

    public final void close() throws IOException {
        this._reader.close();
    }

    public final boolean nextToken() throws IOException {
        this._tokenType = this._st.nextToken();
        switch (this._tokenType) {
            case -7: {
                return this.nextToken();
            }
            case -1: {
                this.setEof();
                break;
            }
            case 10: {
                this.eol();
                break;
            }
            case -5: {
                this._intValue = (int)this._st.nval;
                break;
            }
            case 34: 
            case 39: {
                this._tokenType = -4;
            }
            case -4: {
                this._symbolValue = this._st.sval;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

