/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.util;

import hlt.language.util.IntIterator;
import hlt.osf.base.Sort;
import hlt.osf.exec.Context;
import hlt.osf.exec.LockedCodeArrayException;
import hlt.osf.exec.Taxonomy;
import hlt.osf.util.Decoded;
import hlt.osf.util.LockedBitCodeException;
import java.util.BitSet;
import java.util.HashSet;

public class BitCode
extends BitSet {
    private Decoded _decoded;
    private static char _ON = (char)49;
    private static char _OFF = (char)48;
    private static BitCode _TEMP = new BitCode();
    private boolean _isLocked = false;

    public BitCode() {
    }

    public BitCode(int n) {
        super(n);
    }

    public BitCode setDecoded(Decoded decoded) {
        this._decoded = decoded;
        return this;
    }

    public Decoded decoded() {
        return this._decoded;
    }

    public static void setOnChar(char c) {
        _ON = c;
    }

    public static void setOffChar(char c) {
        _OFF = c;
    }

    public boolean isContainedIn(BitCode bitCode) {
        _TEMP.clear();
        _TEMP.or(this);
        _TEMP.and(bitCode);
        return this.equals(_TEMP);
    }

    public boolean isStrictlyContainedIn(BitCode bitCode) {
        return this.equals(bitCode) ? false : this.isContainedIn(bitCode);
    }

    public boolean isRelatedTo(BitCode bitCode) {
        return this.equals(bitCode) || this.isContainedIn(bitCode) || bitCode.isContainedIn(this);
    }

    public boolean isUnrelatedTo(BitCode bitCode) {
        return !this.isRelatedTo(bitCode);
    }

    public boolean isLocked() {
        return this._isLocked;
    }

    public BitCode lock() {
        this._isLocked = true;
        return this;
    }

    public BitCode unlock() {
        this._isLocked = false;
        return this;
    }

    public BitCode add(int n) throws LockedBitCodeException {
        if (this._isLocked) {
            throw new LockedBitCodeException("Cannot add to a locked BitCode");
        }
        this.set(n);
        return this;
    }

    public BitCode remove(int n) throws LockedBitCodeException {
        if (this._isLocked) {
            throw new LockedBitCodeException("Cannot remove from a locked BitCode");
        }
        this.set(n, false);
        return this;
    }

    public BitCode erase() throws LockedBitCodeException {
        if (this._isLocked) {
            throw new LockedBitCodeException("Cannot clear a locked BitCode");
        }
        super.clear();
        return this;
    }

    public static BitCode not(BitCode bitCode) {
        if (!bitCode.isLocked()) {
            bitCode.flip(0, Sort.codeSize());
            return bitCode;
        }
        BitCode bitCode2 = bitCode.copy();
        bitCode2.flip(0, Sort.codeSize());
        return bitCode2;
    }

    public static BitCode and(BitCode bitCode, BitCode bitCode2) {
        if (!bitCode.isLocked()) {
            bitCode.and(bitCode2);
            return bitCode;
        }
        if (!bitCode2.isLocked()) {
            bitCode2.and(bitCode);
            return bitCode2;
        }
        BitCode bitCode3 = bitCode.copy();
        bitCode3.and(bitCode2);
        return bitCode3;
    }

    public final int first() {
        return this.nextSetBit(0);
    }

    public final int last() {
        return this.length() - 1;
    }

    public static BitCode or(BitCode bitCode, BitCode bitCode2) {
        if (!bitCode.isLocked()) {
            bitCode.or(bitCode2);
            return bitCode;
        }
        if (!bitCode2.isLocked()) {
            bitCode2.or(bitCode);
            return bitCode2;
        }
        BitCode bitCode3 = bitCode.copy();
        bitCode3.or(bitCode2);
        return bitCode3;
    }

    public BitCode copy() {
        if (Context.isTracing()) {
            Context.tallyCodeCopy();
        }
        return ((BitCode)super.clone()).unlock();
    }

    public String toBitString(int n) {
        Object object = "";
        int n2 = n;
        while (n2-- > 0) {
            object = (String)object + (this.get(n2) ? _ON : _OFF);
        }
        return object;
    }

    public String toBitString() {
        return this.toBitString(Sort.codeSize());
    }

    public String toTrueBitString() {
        return this.toBitString(this.length());
    }

    @Override
    public String toString() {
        return this.toBitString() + " " + (this._isLocked ? "[]" : "][");
    }

    public String toSaveFormatString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.nextSetBit(0);
        while (n != -1) {
            int n2 = this.nextClearBit(n);
            stringBuffer = stringBuffer.append(n + " " + n2 + " ");
            n = this.nextSetBit(n2);
        }
        return stringBuffer.toString();
    }

    public HashSet toHashSet(Taxonomy taxonomy) throws LockedCodeArrayException {
        if (!taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Attempt to perform an operation requiring prior sort encoding");
        }
        if (this.isEmpty()) {
            return null;
        }
        HashSet<Sort> hashSet = new HashSet<Sort>(this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            hashSet.add(taxonomy.getSort(intIterator.next()));
        }
        return hashSet;
    }

    public IntIterator iterator() {
        return new BitCodeIterator(this);
    }

    public IntIterator zeroIterator() {
        return new BitCodeZeroIterator(this, Sort.codeSize());
    }

    public IntIterator zeroIterator(int n) {
        return new BitCodeZeroIterator(this, n);
    }

    private class BitCodeZeroIterator
    implements IntIterator {
        private BitCode _code;
        private int _stop;
        private boolean _getNext = true;
        private int _next = -1;

        BitCodeZeroIterator(BitCode bitCode2, int n) {
            this._code = bitCode2;
            this._stop = n - 1;
        }

        @Override
        public final boolean hasNext() {
            if (this._next >= this._stop) {
                return false;
            }
            if (this._getNext) {
                this._next = this._code.nextClearBit(this._next + 1);
                this._getNext = false;
            }
            return this._next >= 0;
        }

        @Override
        public final int next() {
            this._getNext = true;
            return this._next;
        }
    }

    private class BitCodeIterator
    implements IntIterator {
        private BitCode _code;
        private boolean _getNext = true;
        private int _next = -1;

        BitCodeIterator(BitCode bitCode2) {
            this._code = bitCode2;
        }

        @Override
        public final boolean hasNext() {
            if (this._getNext) {
                this._next = this._code.nextSetBit(this._next + 1);
                this._getNext = false;
            }
            return this._next >= 0;
        }

        @Override
        public final int next() {
            this._getNext = true;
            return this._next;
        }
    }
}

