/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.util;

import hlt.language.util.IntIterator;
import hlt.osf.base.Sort;
import hlt.osf.exec.LockedCodeArrayException;
import hlt.osf.exec.Taxonomy;
import hlt.osf.util.BitCode;
import java.util.HashSet;
import java.util.Iterator;

public class Decoded {
    private BitCode _bitcode;
    private Sort _sort;
    private HashSet _lubs;
    private HashSet _glbs;
    private HashSet _descendants;
    private HashSet _ancestors;
    private static Decoded _bottom = new Decoded(Sort.bottom());
    private static Decoded _top = new Decoded(Sort.top());
    private static int _ENUM_SIZE = 10;

    public Decoded(Sort sort) {
        this._sort = sort;
        this._bitcode = sort.bitcode().setDecoded(this);
        if (!sort.isTop()) {
            this._lubs = sort.parents();
        }
        if (!sort.isBottom()) {
            this._glbs = sort.children();
        }
    }

    public Decoded(BitCode bitCode, HashSet hashSet, HashSet hashSet2) {
        this._bitcode = bitCode.setDecoded(this);
        this._lubs = hashSet;
        this._glbs = hashSet2;
    }

    public HashSet descendants(Taxonomy taxonomy) throws LockedCodeArrayException {
        if (!taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Attempt to perform an operation requiring prior sort encoding");
        }
        if (this._descendants != null) {
            return this._descendants;
        }
        if (this.isSort() && this._sort.isBottom()) {
            return null;
        }
        this._descendants = this._bitcode.toHashSet(taxonomy);
        if (this.isSort()) {
            this._descendants.remove(this._sort);
        }
        return this._descendants;
    }

    public HashSet ancestors(Taxonomy taxonomy) {
        if (!taxonomy.isLocked()) {
            throw new LockedCodeArrayException("Attempt to perform an operation requiring prior sort encoding");
        }
        if (this._ancestors != null) {
            return this._ancestors;
        }
        if (this.isSort() && this._sort.isTop()) {
            this._ancestors = new HashSet(0);
            return this._ancestors;
        }
        this._ancestors = new HashSet(this._bitcode.size());
        IntIterator intIterator = this._bitcode.zeroIterator();
        while (intIterator.hasNext()) {
            Sort sort = taxonomy.getSort(intIterator.next());
            if (!this._bitcode.isContainedIn(sort.bitcode())) continue;
            this._ancestors.add(sort);
        }
        return this._ancestors;
    }

    public static Decoded bottom() {
        return _bottom;
    }

    public static Decoded top() {
        return _top;
    }

    public boolean isSort() {
        return this._sort != null;
    }

    public Sort sort() {
        return this._sort;
    }

    public BitCode bitcode() {
        return this._bitcode;
    }

    public HashSet glbs() {
        return this._glbs;
    }

    public HashSet lubs() {
        return this._lubs;
    }

    public String toString() {
        String string;
        String string2 = this._lubs == null ? (this._sort == null ? "*EVERYTHING*" : "") : this._enum(this._lubs);
        String string3 = string = this._sort == null ? "" : this._sort.toString();
        String string4 = this._glbs == null ? (this._sort == null ? "*NOTHING*" : "") : this._enum(this._glbs);
        return "\nLEAST SUPERSORTS:  " + string2 + "\nEQUIVALENT SORT:   " + string + "\nGREATEST SUBSORTS: " + string4 + "\n";
    }

    public static int enumSize() {
        return _ENUM_SIZE;
    }

    public static int resetEnumSize() {
        _ENUM_SIZE = 10;
        return 10;
    }

    public static int setEnumSize(int n) {
        _ENUM_SIZE = n;
        return _ENUM_SIZE;
    }

    private String _enum(HashSet hashSet) {
        if (hashSet.isEmpty()) {
            return Sort.bottom().toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (++n == _ENUM_SIZE) {
                stringBuffer.append(" ... (" + hashSet.size() + " elements in total)");
                break;
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

