/*
 * Decompiled with CFR 0.152.
 */
package hlt.osf.util;

import java.util.Iterator;
import java.util.LinkedList;

public class DoublyLinkedList {
    private Cell _first = null;
    private Cell _last = null;
    private int _length = 0;

    public DoublyLinkedList() {
    }

    public DoublyLinkedList(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.append(iterator.next());
        }
    }

    public DoublyLinkedList(Object[] objectArray) {
        int n = objectArray.length;
        while (n-- > 0) {
            this.prepend(objectArray[n]);
        }
    }

    Cell first() {
        return this._first;
    }

    public Object firstElt() {
        return this._first.elt();
    }

    Cell last() {
        return this._last;
    }

    public Object lastElt() {
        return this._last.elt();
    }

    public int length() {
        return this._length;
    }

    public boolean isEmpty() {
        return this._length == 0;
    }

    public DoublyLinkedList prepend(Object object) {
        Cell cell = new Cell(object);
        if (this.isEmpty()) {
            this._first = cell;
            this._last = cell;
            this._length = 1;
        } else {
            cell.setNext(this._first);
            this._first.setPrev(cell);
            this._first = cell;
            ++this._length;
        }
        return this;
    }

    public DoublyLinkedList append(Object object) {
        Cell cell = new Cell(object);
        if (this.isEmpty()) {
            this._first = cell;
            this._last = cell;
            this._length = 1;
        } else {
            cell.setPrev(this._last);
            this._last.setNext(cell);
            this._last = cell;
            ++this._length;
        }
        return this;
    }

    public DoublyLinkedList concatenate(DoublyLinkedList doublyLinkedList) {
        if (this.isEmpty()) {
            this._first = doublyLinkedList.first();
            this._last = doublyLinkedList.last();
            this._length = doublyLinkedList.length();
        } else {
            doublyLinkedList.first().setPrev(this._last);
            this._last.setNext(doublyLinkedList.first());
            this._last = doublyLinkedList.last();
            this._length += doublyLinkedList.length();
        }
        return this;
    }

    public void clear() {
        this._first = null;
        this._last = null;
        this._length = 0;
    }

    public Object clone() {
        return this.copy();
    }

    public DoublyLinkedList copy() {
        DoublyLinkedList doublyLinkedList = new DoublyLinkedList();
        if (!this.isEmpty()) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                doublyLinkedList.append(iterator.next());
            }
        }
        return doublyLinkedList;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoublyLinkedList)) {
            return false;
        }
        DoublyLinkedList doublyLinkedList = (DoublyLinkedList)object;
        if (this._length != doublyLinkedList.length()) {
            return false;
        }
        if (!this.isEmpty()) {
            Cell cell = this._first;
            Cell cell2 = doublyLinkedList.first();
            while (cell != this._last) {
                if (cell.elt().equals(cell2.elt())) {
                    cell = cell.next();
                    cell2 = cell2.next();
                    continue;
                }
                return cell.elt().equals(cell2.elt());
            }
        }
        return true;
    }

    public int hashCode() {
        if (this._length == 0) {
            return 1;
        }
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n / this._length;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (Cell cell = this._first; cell != this._last; cell = cell.next()) {
            stringBuffer.append(cell.elt() + ",");
        }
        stringBuffer.append(this._last.elt() + "]");
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new DoublyLinkedListIterator(this);
    }

    class Cell {
        private Object _elt = null;
        private Cell _next = null;
        private Cell _prev = null;

        Cell(Object object) {
            this._elt = object;
        }

        Object elt() {
            return this._elt;
        }

        Cell next() {
            return this._next;
        }

        Cell prev() {
            return this._prev;
        }

        void setNext(Cell cell) {
            this._next = cell;
        }

        void setPrev(Cell cell) {
            this._prev = cell;
        }

        public String toString() {
            return this._elt.toString();
        }
    }

    private class DoublyLinkedListIterator
    implements Iterator {
        private Cell _current;

        DoublyLinkedListIterator(DoublyLinkedList doublyLinkedList2) {
            this._current = doublyLinkedList2.first();
        }

        @Override
        public final boolean hasNext() {
            return this._current != null;
        }

        public final Object next() {
            Object object = this._current.elt();
            this._current = this._current.next();
            return object;
        }

        @Override
        public final void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

